/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg.processor.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Map;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.TJTransform;
import org.libjpegturbo.turbojpeg.TJTransformer;
import org.libjpegturbo.turbojpeg.processor.api.ImageProcessException;
import org.libjpegturbo.turbojpeg.processor.api.ImageProcessInfo;
import org.libjpegturbo.turbojpeg.processor.api.ImageProcessor;

public class ImageProcessorImpl
implements ImageProcessor {
    static TJScalingFactor[] sf = null;

    @Override
    public boolean isUsable() {
        return TJ.isUsable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BufferedImage decompressGeneralImage(byte[] inImage, int numerator, int denominator, int flags) throws ImageProcessException {
        ImageProcessorImpl.checkUsable();
        ImageProcessorImpl.checkInputImage(inImage);
        try (TJDecompressor decompressor = ImageProcessorImpl.createDecompressor(inImage, new TJTransform());){
            BufferedImage decompImage;
            TJScalingFactor scaleFactor = new TJScalingFactor(numerator, denominator);
            int width = scaleFactor.getScaled(decompressor.getWidth());
            int height = scaleFactor.getScaled(decompressor.getHeight());
            BufferedImage bufferedImage = decompImage = decompressor.decompress(width, height, 1, flags);
            return bufferedImage;
        }
        catch (Exception e) {
            throw new ImageProcessException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> decompressJpegImage(byte[] inImage, int numerator, int denominator, int flags) throws ImageProcessException {
        ImageProcessorImpl.checkUsable();
        ImageProcessorImpl.checkInputImage(inImage);
        try (TJDecompressor decompressor = ImageProcessorImpl.createDecompressor(inImage, new TJTransform());){
            TJScalingFactor scaleFactor = new TJScalingFactor(numerator, denominator);
            int width = scaleFactor.getScaled(decompressor.getWidth());
            int height = scaleFactor.getScaled(decompressor.getHeight());
            byte[] bmpBuffer = decompressor.decompress(width, 0, height, 3, flags);
            ImageProcessInfo info = ImageProcessInfo.newInstance().setInputWidth(width).setInputHeight(height).setOutputWidth(width).setOutputHeight(height).setOutputImage(bmpBuffer).setOutputImageSize(decompressor.getJPEGSize());
            Map<String, Object> map = info.toMap();
            return map;
        }
        catch (Exception e) {
            throw new ImageProcessException(e);
        }
    }

    @Override
    public ByteArrayInputStream compressGeneralImage(BufferedImage inImage, int quality, int subsampling, int flags) throws ImageProcessException {
        return ImageProcessorImpl.compressImage(inImage, 0, 0, quality, subsampling, flags);
    }

    @Override
    public ByteArrayInputStream compressJpegImage(byte[] inImage, int width, int height, int quality, int subsampling, int flags) throws ImageProcessException {
        return ImageProcessorImpl.compressImage(inImage, width, height, quality, subsampling, flags);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ByteArrayInputStream compressImage(Object inImage, int width, int height, int quality, int subsampling, int flags) throws ImageProcessException {
        ImageProcessorImpl.checkUsable();
        ImageProcessorImpl.checkInputImage(inImage);
        try (TJCompressor compressor = ImageProcessorImpl.createCompressor(quality, subsampling);){
            if (inImage instanceof BufferedImage) {
                compressor.setSourceImage((BufferedImage)inImage, 0, 0, 0, 0);
            } else {
                compressor.setSourceImage((byte[])inImage, 0, 0, width, 0, height, 3);
            }
            byte[] data = compressor.compress(flags);
            int size = compressor.getCompressedSize();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data, 0, size);
            return byteArrayInputStream;
        }
        catch (Exception e) {
            throw new ImageProcessException(e);
        }
    }

    protected static TJDecompressor createDecompressor(byte[] image, TJTransform transform) throws Exception {
        TJDecompressor decompressor = null;
        if (transform.op != 0 || transform.options != 0 || transform.cf != null) {
            TJTransform[] transforms = new TJTransform[]{transform};
            transforms[0].options |= 2;
            TJTransformer transformer = new TJTransformer(image);
            TJDecompressor[] decompressors = transformer.transform(transforms, 0);
            decompressor = decompressors[0];
        } else {
            decompressor = new TJDecompressor(image);
        }
        return decompressor;
    }

    protected static TJCompressor createCompressor(int quality, int subsamp) throws Exception {
        TJCompressor compressor = new TJCompressor();
        compressor.setJPEGQuality(quality);
        compressor.setSubsamp(subsamp);
        return compressor;
    }

    protected static void checkUsable() throws ImageProcessException {
        if (!TJ.isUsable()) {
            throw new ImageProcessException("Native library can't be used at the current platform");
        }
    }

    protected static void checkInputImage(Object inImage) throws ImageProcessException {
        if (inImage == null) {
            throw new ImageProcessException("Input image can't be null");
        }
    }

    static {
        try {
            sf = TJ.getScalingFactors();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

