/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.libjpegturbo.turbojpeg.DigestUtils;
import org.libjpegturbo.turbojpeg.OSInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdvancedTJLoader {
    static final String LIB_VERSION_DEFAULT = "3.1";
    public static final String KEY_LIB_PATH = "mozjpeg.native.lib.path";
    public static final String KEY_LIB_NAME = "mozjpeg.native.lib.name";
    public static final String KEY_LIB_VERSION = "mozjpeg.native.lib.internal.version";
    public static final String KEY_LIB_SIMD_DISABLED = "mozjpeg.native.lib.internal.simd.disabled";
    public static final String KEY_LIB_RENEWED = "mozjpeg.native.lib.internal.renewed";
    protected static final String LIB_PATH_INTERNAL_PREFIX = "native_mozjpeg";
    protected static final String LIB_NAME = "libturbojpeg";
    protected static final String LIB_NAME_GENERIC = "turbojpeg";
    protected static volatile String loadedLibPath = null;
    protected static volatile String internalLibVersion = null;
    protected static volatile boolean internalLibRenewed = false;
    protected static volatile boolean internalSimdDisabled = false;
    private static final Logger log = LoggerFactory.getLogger(AdvancedTJLoader.class);

    AdvancedTJLoader() {
    }

    protected static Map<String, String> getLibrariesData() {
        return new HashMap<String, String>(){
            {
                this.put("/native_mozjpeg/version_3_1/linux_simd_disabled_x86/libturbojpeg.so", "8c7207433b0440bd09617c316b4a0c5d");
                this.put("/native_mozjpeg/version_3_1/linux_simd_disabled_x86_64/libturbojpeg.so", "e235c8d1cc9bdeeda3d6aed73af8c21f");
                this.put("/native_mozjpeg/version_3_1/linux_simd_enabled_x86_64/libturbojpeg.so", "bd9d9366848e7e4a5431a95eb54c6302");
                this.put("/native_mozjpeg/version_3_1/mac_simd_enabled_x86_64/libturbojpeg.dylib", "96c972b96aa87034bf073423dd5b4341");
                this.put("/native_mozjpeg/version_3_1/mac_simd_disabled_x86_64/libturbojpeg.dylib", "83fe0a59e99c2fe9dba1695fd09a0cda");
                this.put("/native_mozjpeg/version_3_1/windows_simd_disabled_x86/libturbojpeg.dll", "b7110b82fbb93d5825e06d0e1ea95bd5");
                this.put("/native_mozjpeg/version_3_1/windows_simd_disabled_x86_64/libturbojpeg.dll", "48ab9dc574c2d4c6c27ac135deae15c1");
                this.put("/native_mozjpeg/version_3_1/windows_simd_enabled_x86_64/libturbojpeg.dll", "7bdd42d0e63f0bdd18922a374bfb0fc6");
            }
        };
    }

    protected static void load() {
        try {
            AdvancedTJLoader.loadUnsafe();
        }
        catch (Throwable t) {
            log.error("Native library couldn't be loaded", t);
        }
    }

    protected static void loadUnsafe() throws IOException {
        String fullLibPath;
        File libFile;
        String libPath;
        String libName;
        if (AdvancedTJLoader.isLibraryLoaded()) {
            return;
        }
        internalSimdDisabled = Boolean.parseBoolean(System.getProperty(KEY_LIB_SIMD_DISABLED));
        if (OSInfo.getJVMArch() == OSInfo.OSArch.x86) {
            internalSimdDisabled = true;
        }
        internalLibRenewed = Boolean.parseBoolean(System.getProperty(KEY_LIB_RENEWED));
        internalLibVersion = System.getProperty(KEY_LIB_VERSION, LIB_VERSION_DEFAULT);
        if (internalLibRenewed) {
            new File(AdvancedTJLoader.getFullExtractedLibraryPath()).delete();
        }
        if ((libName = System.getProperty(KEY_LIB_NAME)) == null || libName.isEmpty()) {
            libName = AdvancedTJLoader.getLibraryInternalName();
        }
        if ((libPath = System.getProperty(KEY_LIB_PATH)) == null || libPath.isEmpty()) {
            libPath = AdvancedTJLoader.getExtractedLibraryPath();
        }
        if (!(libFile = new File(fullLibPath = libPath + File.separator + libName)).exists() || libFile.length() == 0L) {
            log.debug("Extracting native mozjpeg library becuase it's not found at {}", (Object)fullLibPath);
            AdvancedTJLoader.extractNativeLibraryWithRetrial();
            fullLibPath = AdvancedTJLoader.getFullExtractedLibraryPath();
        }
        if ((loadedLibPath = AdvancedTJLoader.loadNativeLibrary(fullLibPath) ? fullLibPath : AdvancedTJLoader.loadNativeLibraryFromOS()) == null) {
            throw new IOException("Native library could not be loaded: " + libName);
        }
    }

    protected static String loadNativeLibraryFromOS() {
        String result = null;
        try {
            System.loadLibrary(LIB_NAME_GENERIC);
            result = LIB_NAME_GENERIC;
        }
        catch (Throwable t) {
            if (OSInfo.getOSName() == OSInfo.OSName.mac) {
                try {
                    String optPath = "/opt/mozjpeg/lib/" + AdvancedTJLoader.getLibraryInternalName();
                    System.load(optPath);
                    result = optPath;
                }
                catch (Throwable t2) {
                    String usrPath = "/usr/lib/" + AdvancedTJLoader.getLibraryInternalName();
                    System.load(usrPath);
                    result = usrPath;
                }
            }
            String optPath = "/opt/mozjpeg/lib64/libturbojpeg.so";
            System.load(optPath);
            result = optPath;
        }
        return result;
    }

    protected static boolean loadNativeLibrary(String fullLibPath) {
        boolean result = false;
        if (new File(fullLibPath).exists()) {
            try {
                System.load(fullLibPath);
                result = true;
            }
            catch (Throwable t) {
                log.error("Error loading native library", t);
            }
        }
        return result;
    }

    protected static void extractNativeLibraryWithRetrial() throws IOException {
        String internalLibPath = AdvancedTJLoader.getLibraryFullInternalPath("/");
        String extractedLibPath = AdvancedTJLoader.getFullExtractedLibraryPath();
        AdvancedTJLoader.extractNativeLibrary(internalLibPath, extractedLibPath);
        boolean md5Matches = true;
        try {
            md5Matches = AdvancedTJLoader.verifyExtractedLibraryMD5(internalLibPath, extractedLibPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!md5Matches) {
            new File(extractedLibPath).delete();
            AdvancedTJLoader.extractNativeLibrary(internalLibPath, extractedLibPath);
            try {
                md5Matches = AdvancedTJLoader.verifyExtractedLibraryMD5(internalLibPath, extractedLibPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!md5Matches) {
            throw new IOException("MD5 for internal and extracted libraries don't match");
        }
    }

    protected static void extractNativeLibrary(String internalLibPath, String extractedLibPath) throws IOException {
        int bytesRead;
        InputStream reader;
        File extractedLibFile = new File(extractedLibPath);
        File parentFile = extractedLibFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        if ((reader = AdvancedTJLoader.class.getResourceAsStream(internalLibPath)) == null) {
            throw new IOException("Internal library is not found: " + internalLibPath);
        }
        FileOutputStream writer = new FileOutputStream(extractedLibFile);
        byte[] buffer = new byte[2048];
        while ((bytesRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, bytesRead);
        }
        writer.close();
        reader.close();
    }

    protected static boolean verifyExtractedLibraryMD5(String internalLibPath, String extractedLibPath) throws NoSuchAlgorithmException, IOException {
        Map<String, String> libsData = AdvancedTJLoader.getLibrariesData();
        String expectedMD5 = libsData.get(internalLibPath);
        if (expectedMD5 != null) {
            String libMD5 = DigestUtils.getFileMD5(new File(extractedLibPath));
            if (!expectedMD5.equalsIgnoreCase(libMD5)) {
                log.error("Expected MD5 of the library is " + expectedMD5 + " but found " + libMD5 + ". Library path: " + extractedLibPath);
                return false;
            }
        } else {
            log.error("The internal library checksum is not found. Please consider adding it to the code.");
        }
        return true;
    }

    protected static String getLibraryInternalVersionPath() {
        return "version_" + AdvancedTJLoader.getInternalLibVersion().replaceAll("\\.", "_");
    }

    protected static String getLibraryInternalName() {
        return LIB_NAME + OSInfo.getOSName().getLibExtension();
    }

    protected static String getInternalLibraryPath(String separator) {
        String simdProp = internalSimdDisabled ? "simd_disabled" : "simd_enabled";
        OSInfo.OSName osName = OSInfo.getOSName();
        return separator + LIB_PATH_INTERNAL_PREFIX + separator + AdvancedTJLoader.getLibraryInternalVersionPath() + separator + osName.toString() + "_" + simdProp + "_" + OSInfo.getJVMArch().toString();
    }

    protected static String getLibraryFullInternalPath(String separator) {
        return AdvancedTJLoader.getInternalLibraryPath(separator) + separator + AdvancedTJLoader.getLibraryInternalName();
    }

    protected static String getExtractedLibraryPath() {
        return OSInfo.getExecutableTempDirectory() + AdvancedTJLoader.getInternalLibraryPath(File.separator);
    }

    protected static String getFullExtractedLibraryPath() {
        return OSInfo.getExecutableTempDirectory() + AdvancedTJLoader.getLibraryFullInternalPath(File.separator);
    }

    public static String getInternalLibVersion() {
        return internalLibVersion;
    }

    public static boolean isInternalSimdDisabled() {
        return internalSimdDisabled;
    }

    public static String getLoadedLibraryPath() {
        return loadedLibPath;
    }

    public static boolean isLibraryLoaded() {
        return loadedLibPath != null;
    }

    public static boolean isLibraryLoadedFromInternalResource() {
        return AdvancedTJLoader.isLibraryLoaded() && loadedLibPath.equalsIgnoreCase(AdvancedTJLoader.getFullExtractedLibraryPath());
    }

    public static boolean isInternalLibraryRenewed() {
        return internalLibRenewed;
    }
}

