/*
 * Decompiled with CFR 0.152.
 */
package org.pngquant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

abstract class LiqObject {
    long handle;

    LiqObject() {
    }

    public static void loadLibrary() throws IOException {
        File directory = new File(System.getProperty("java.io.tmpdir"), "libimagequant_extracted_from_classpath");
        if (!directory.exists() && !directory.mkdirs()) {
            throw new RuntimeException("create libimagequant library dir failed!");
        }
        FileUtils.cleanDirectory((File)directory);
        FileUtils.copyInputStreamToFile((InputStream)LiqObject.getResourceAsStream(File.separator + "libimagequant" + File.separator + "libimagequant.jnilib"), (File)new File(directory, "libimagequant.jnilib"));
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            System.load(directory.getPath() + File.separator + "libimagequant.jnilib");
        } else if (System.getProperty("os.name").toLowerCase().contains("win")) {
            System.load(directory.getPath() + File.separator + "libimagequant.dll");
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            System.load(directory.getPath() + File.separator + "libimagequant.so");
        } else {
            throw new RuntimeException("unsupported os for libimagequant");
        }
    }

    private static InputStream getResourceAsStream(String resource) {
        InputStream in = LiqObject.getContextClassLoader().getResourceAsStream(resource);
        return in == null ? LiqObject.class.getResourceAsStream(resource) : in;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public abstract void close();

    protected void finalize() throws Throwable {
        this.close();
    }

    static {
        try {
            LiqObject.loadLibrary();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

