/*
 * Decompiled with CFR 0.152.
 */
package org.pngquant;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import org.pngquant.Image;
import org.pngquant.LiqObject;
import org.pngquant.PngQuant;
import org.pngquant.PngQuantException;

public class Result
extends LiqObject {
    public Result(PngQuant pngquant, Image image) throws PngQuantException {
        this.handle = Result.liq_quantize_image(pngquant.handle, image.handle);
        if (this.handle == 0L) {
            throw new PngQuantException();
        }
    }

    public BufferedImage getRemapped(Image orig_image) {
        byte[] pal = Result.liq_get_palette(this.handle);
        IndexColorModel color = new IndexColorModel(8, pal.length / 4, pal, 0, true);
        BufferedImage img = new BufferedImage(orig_image.getWidth(), orig_image.getHeight(), 13, color);
        byte[] data = Result.get8bitDataFromImage(img);
        if (data == null) {
            return null;
        }
        if (!Result.liq_write_remapped_image(this.handle, orig_image.handle, data)) {
            return null;
        }
        return img;
    }

    public native boolean setDitheringLevel(float var1);

    public native boolean setGamma(double var1);

    public native double getGamma();

    public native double getMeanSquareError();

    public native int getQuality();

    @Override
    public void close() {
        if (this.handle != 0L) {
            Result.liq_result_destroy(this.handle);
            this.handle = 0L;
        }
    }

    private static byte[] get8bitDataFromImage(BufferedImage image) {
        DataBuffer buffer;
        if (image.getType() == 13 && (buffer = image.getRaster().getDataBuffer()) instanceof DataBufferByte) {
            return ((DataBufferByte)buffer).getData();
        }
        return null;
    }

    private static native byte[] liq_get_palette(long var0);

    private static native long liq_quantize_image(long var0, long var2);

    private static native boolean liq_write_remapped_image(long var0, long var2, byte[] var4);

    private static native void liq_result_destroy(long var0);
}

