/*
 * Decompiled with CFR 0.152.
 */
package org.pngquant;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import org.pngquant.LiqObject;
import org.pngquant.PngQuant;
import org.pngquant.PngQuantException;

public class Image
extends LiqObject {
    public Image(BufferedImage image) throws PngQuantException {
        this(new PngQuant(), image);
    }

    public Image(PngQuant attr, BufferedImage image) throws PngQuantException {
        this.handle = Image.handleFromImage(attr, image);
        if (this.handle == 0L) {
            BufferedImage converted = new BufferedImage(image.getWidth(), image.getHeight(), 6);
            converted.getGraphics().drawImage(image, 0, 0, null);
            this.handle = Image.handleFromImage(attr, converted);
            if (this.handle == 0L) {
                throw new PngQuantException();
            }
        }
    }

    public native boolean addFixedColor(int var1, int var2, int var3, int var4);

    public boolean addFixedColor(int r, int g, int b) {
        return this.addFixedColor(r, g, b, 255);
    }

    public native int getWidth();

    public native int getHeight();

    @Override
    public void close() {
        if (this.handle != 0L) {
            Image.liq_image_destroy(this.handle);
            this.handle = 0L;
        }
    }

    private static long handleFromImage(PngQuant attr, BufferedImage image) {
        DataBuffer buffer;
        int type = image.getType();
        if (type != 5 && type != 6 && type != 7) {
            return 0L;
        }
        WritableRaster raster = image.getRaster();
        ColorModel color = image.getColorModel();
        if (type == 7) {
            color.coerceData(raster, false);
        }
        if ((buffer = raster.getDataBuffer()) instanceof DataBufferByte) {
            byte[] imageData = ((DataBufferByte)buffer).getData();
            return Image.liq_image_create(attr.handle, imageData, raster.getWidth(), raster.getHeight(), color.getNumComponents());
        }
        return 0L;
    }

    private static native long liq_image_create(long var0, byte[] var2, int var3, int var4, int var5);

    private static native void liq_image_destroy(long var0);
}

