/*
 * Decompiled with CFR 0.152.
 */
package org.pngquant;

import java.awt.image.BufferedImage;
import org.pngquant.Image;
import org.pngquant.LiqObject;
import org.pngquant.PngQuantException;
import org.pngquant.Result;

public class PngQuant
extends LiqObject {
    public PngQuant() {
        this.handle = PngQuant.liq_attr_create();
    }

    public PngQuant(PngQuant other) {
        this.handle = PngQuant.liq_attr_copy(other.handle);
    }

    public BufferedImage getRemapped(BufferedImage bufimg) {
        try {
            Image liqimg = new Image(this, bufimg);
            BufferedImage remapped = this.getRemapped(liqimg);
            liqimg.close();
            return remapped;
        }
        catch (PngQuantException e) {
            return null;
        }
    }

    public BufferedImage getRemapped(Image liqimg) {
        Result result = this.quantize(liqimg);
        if (result == null) {
            return null;
        }
        BufferedImage remapped = result.getRemapped(liqimg);
        result.close();
        return remapped;
    }

    public Result quantize(Image img) {
        try {
            return new Result(this, img);
        }
        catch (PngQuantException e) {
            return null;
        }
    }

    public native boolean setMaxColors(int var1);

    public native boolean setQuality(int var1);

    public native boolean setQuality(int var1, int var2);

    public native boolean setSpeed(int var1);

    public native boolean setMinPosterization(int var1);

    @Override
    public void close() {
        if (this.handle != 0L) {
            PngQuant.liq_attr_destroy(this.handle);
            this.handle = 0L;
        }
    }

    private static native long liq_attr_create();

    private static native long liq_attr_copy(long var0);

    private static native void liq_attr_destroy(long var0);
}

