/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.eInvoice.mycrypto;

import com.alipay.mychain.eInvoice.mycrypto.MyCryptoStatus;
import com.alipay.mychain.eInvoice.mycrypto.NativeUtils;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadNativeMyCrypto {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadNativeMyCrypto.class);
    private static String LIB_NAME = "mycrypto_jni";
    private static boolean LOADED;
    private static SecureRandom secureRandom;

    private LoadNativeMyCrypto() {
    }

    public static boolean isNative() {
        return LOADED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadNativeLibrary() {
        Class<LoadNativeMyCrypto> clazz = LoadNativeMyCrypto.class;
        synchronized (LoadNativeMyCrypto.class) {
            if (LOADED) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return LOADED;
            }
            try {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.indexOf("windows") >= 0) {
                    LIB_NAME = "libmycrypto_jni";
                }
                LOADED = NativeUtils.loadLibraryFromJar("/META-INF/native/" + System.mapLibraryName(LIB_NAME));
                if (LoadNativeMyCrypto.verify().getCode() != 1) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("mycrypto not supported! Use SecureRandom");
                    }
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return false;
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("rdrand & mycrypto supported");
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            catch (Exception e) {
                LOGGER.error(e.toString(), (Throwable)e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return LOADED;
            }
        }
    }

    private static native int isRDRANDSupported();

    public static MyCryptoStatus verify() {
        int result = LoadNativeMyCrypto.isRDRANDSupported();
        return MyCryptoStatus.getStatusByCode(result);
    }

    public static native int nextBytesNative(byte[] var0, int var1);

    public static void nextBytes(byte[] bytes) {
        if (LOADED) {
            int result = LoadNativeMyCrypto.nextBytesNative(bytes, bytes.length);
            MyCryptoStatus status = MyCryptoStatus.getStatusByCode(result);
            MyCryptoStatus.checkState(status == MyCryptoStatus.SUCCESS, "invalid MyCryptoStatus:" + (Object)((Object)status));
        } else {
            secureRandom.nextBytes(bytes);
        }
    }

    public static native int sm3HashNative(byte[] var0, byte[] var1, int var2);

    public static native int sm3KDFNative(byte[] var0, int var1, byte[] var2, int var3);

    public static native int sm4CbcEncryptWithMacNative(byte[] var0, byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, int[] var6);

    public static native int sm4CbcDecryptWithMacNative(byte[] var0, byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, int[] var6);

    static {
        try {
            LOADED = LoadNativeMyCrypto.loadNativeLibrary();
            secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }
}

