/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service;

import com.alipay.mychain.sdk.api.MychainClient;
import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.env.ClientEnv;
import com.alipay.mychain.sdk.api.service.BaseService;
import com.alipay.mychain.sdk.api.service.event.EventConnectCallback;
import com.alipay.mychain.sdk.api.service.event.EventInfo;
import com.alipay.mychain.sdk.api.service.event.EventManager;
import com.alipay.mychain.sdk.api.service.event.EventRegisterTask;
import com.alipay.mychain.sdk.api.service.event.EventTask;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.event.EventDataType;
import com.alipay.mychain.sdk.domain.event.EventModelType;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.event.CancelEventRequest;
import com.alipay.mychain.sdk.message.event.ListenAccountEventRequest;
import com.alipay.mychain.sdk.message.event.ListenBlockEventRequest;
import com.alipay.mychain.sdk.message.event.ListenContractEventRequest;
import com.alipay.mychain.sdk.message.event.ListenEventResponse;
import com.alipay.mychain.sdk.message.event.ListenTopicsEventRequest;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventService
extends BaseService {
    private static Set<String> TOPICS = new HashSet<String>(Arrays.asList("create_account", "deploy_contract", "call_contract", "add_node", "activate_node", "delete_node", "update_config", "transfer_balance", "set_recover_key", "update_auth_map", "pre_reset_pub_key", "reset_pub_key", "update_contract", "deposit_data", "related_deposit_data", "update_encryption_key", "freeze_account_contract", "unfreeze_account_contract", "encryption_envelope", "deposit_envelope"));
    private EventManager eventManager = new EventManager();
    private TimerTaskManager timerTaskManager;

    public EventService(INetwork client, TimerTaskManager timerTaskManager, ClientEnv env) {
        super(client, timerTaskManager, env);
    }

    @Override
    public boolean start(MychainClient client) {
        if (client == null) {
            return false;
        }
        if (client.getTimerTaskManager() == null) {
            return false;
        }
        this.timerTaskManager = client.getTimerTaskManager();
        if (this.timerTaskManager == null) {
            return false;
        }
        if (this.getNetwork() != null) {
            this.getNetwork().registerEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_ACCOUNT, new IEventCallback(){

                @Override
                public void onEvent(Message message) {
                    EventService.this.eventManager.pushAccountEventHandler(message);
                }
            });
            this.getNetwork().registerEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_CONTRACT, new IEventCallback(){

                @Override
                public void onEvent(Message message) {
                    EventService.this.eventManager.pushContractEventHandler(message);
                }
            });
            this.getNetwork().registerEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_TOPICS, new IEventCallback(){

                @Override
                public void onEvent(Message message) {
                    EventService.this.eventManager.pushTopicsEventHandler(message);
                }
            });
            this.getNetwork().registerEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_BLOCK, new IEventCallback(){

                @Override
                public void onEvent(Message message) {
                    EventService.this.eventManager.pushBlockEventHandler(message);
                }
            });
            this.getNetwork().registerConnectionEventHandler(new EventConnectCallback(this));
        }
        return true;
    }

    @Override
    public boolean stop() {
        if (this.getNetwork() != null) {
            this.getNetwork().unRegisterEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_CONTRACT);
            this.getNetwork().unRegisterEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_TOPICS);
            this.getNetwork().unRegisterEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_ACCOUNT);
            this.getNetwork().unRegisterEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_BLOCK);
        }
        List<EventInfo> eventInfos = this.eventManager.getAllEvent();
        for (EventInfo info : eventInfos) {
            this.unListenEvent(info.getUserEventId(), false);
        }
        return true;
    }

    public BigInteger listenAccount(Identity id, IEventCallback handler, EventModelType type) {
        ListenAccountEventRequest listenAccountEventRequest = new ListenAccountEventRequest(id, type);
        return this.listenEvent(listenAccountEventRequest, handler, EventDataType.ACCOUNT, type);
    }

    public BigInteger listenContract(Identity id, IEventCallback handler, EventModelType type) {
        ListenContractEventRequest listenContractEventRequest = new ListenContractEventRequest(id, type);
        return this.listenEvent(listenContractEventRequest, handler, EventDataType.CONTRACT, type);
    }

    public BigInteger listenTopics(List<String> topics, IEventCallback handler, VMTypeEnum vmType, EventModelType type) {
        ArrayList<String> data = new ArrayList<String>();
        if (VMTypeEnum.EVM.getCode() == vmType.getCode()) {
            for (String topic : topics) {
                if (TOPICS.contains(topic)) {
                    data.add(topic);
                    continue;
                }
                data.add(ByteUtils.toHexString(HashFactory.getHash(HashTypeEnum.Keccak).hash(ByteUtils.stringToByteArray(topic))));
            }
        } else if (VMTypeEnum.WASM.getCode() == vmType.getCode()) {
            for (String topic : topics) {
                if (TOPICS.contains(topic)) {
                    data.add(topic);
                    continue;
                }
                data.add(ByteUtils.toHexString(topic));
            }
        } else {
            return BigInteger.ZERO;
        }
        ListenTopicsEventRequest eventTopics = new ListenTopicsEventRequest(data, type);
        return this.listenEvent(eventTopics, handler, EventDataType.TOPIC, type);
    }

    public BigInteger listenBlock(IEventCallback handler, EventModelType type) {
        ListenBlockEventRequest listenBlockEventRequest = new ListenBlockEventRequest(type);
        return this.listenEvent(listenBlockEventRequest, handler, EventDataType.BLOCK, type);
    }

    public boolean unListenAccount(BigInteger eventId) {
        return this.unListenEvent(eventId, true);
    }

    public boolean unListenContract(BigInteger eventId) {
        return this.unListenEvent(eventId, true);
    }

    public boolean unListenTopics(BigInteger eventId) {
        return this.unListenEvent(eventId, true);
    }

    public boolean unListenBlock(BigInteger eventId) {
        return this.unListenEvent(eventId, true);
    }

    public BigInteger listenEvent(Request request, IEventCallback cb, EventDataType dataType, EventModelType modelType) {
        Response response = this.sendSyncRequest(request);
        if (response != null && response.isSuccess()) {
            ListenEventResponse listenEventResponse = (ListenEventResponse)response;
            EventInfo eventInfo = new EventInfo(request, cb, dataType, modelType);
            eventInfo.setServerEventId(listenEventResponse.getEventId());
            if (this.timerTaskManager != null && EventModelType.PULL.getCode() == eventInfo.getEventModelType().getCode()) {
                EventTask eventTask = new EventTask(eventInfo, this.getNetwork(), this.getEnv().getLogger(), this.getEnv().getRequestOption().getSendRequestTimeoutMs());
                Long taskId = this.timerTaskManager.registerTask(eventTask);
                this.getEnv().getLogger().debug("listenEvent, task id: {}", (Object)taskId);
            }
            return this.eventManager.addEvent(eventInfo);
        }
        return BigInteger.ZERO;
    }

    private boolean unListenEvent(BigInteger userEventId, boolean unListenServer) {
        this.getEnv().getLogger().debug("unListenEvent, event id:" + userEventId);
        EventInfo eventInfo = this.eventManager.delEvent(userEventId);
        if (eventInfo == null) {
            return false;
        }
        if (this.timerTaskManager != null && EventModelType.PULL.getCode() == eventInfo.getEventModelType().getCode()) {
            this.timerTaskManager.unRegisterTask(eventInfo.getTaskId());
        }
        if (unListenServer) {
            ArrayList<BigInteger> ids = new ArrayList<BigInteger>();
            ids.add(eventInfo.getServerEventId());
            if (ids.isEmpty()) {
                return false;
            }
            CancelEventRequest cancelEventRequest = new CancelEventRequest(ids);
            this.sendSyncRequest(cancelEventRequest);
        }
        return true;
    }

    public void reRegisterAllEvent() {
        List<EventInfo> events = this.eventManager.getAllEvent();
        for (EventInfo info : events) {
            this.unListenEvent(info.getUserEventId(), false);
            BigInteger eventId = this.listenEvent(info.getRequest(), info.getHandler(), info.getDataType(), info.getEventModelType());
            if (BigInteger.ZERO.compareTo(eventId) != 0) continue;
            EventRegisterTask eventRegisterTask = new EventRegisterTask(this, this.timerTaskManager, info.getRequest(), info.getHandler(), info.getDataType(), info.getEventModelType(), this.getEnv().getLogger());
            this.timerTaskManager.registerTask(eventRegisterTask);
        }
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

