/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.crypto.pkeycipher.RSAPkeyCipherV1;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class RSAEnvelopeV1
implements EnvelopeBase {
    private static final int NOONCE_IV_LEN = 12;
    private static final int GCM_PARAMETER_LEN = 16;
    private static final int SEALED_KEY_LENGTH = 262;
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase privkey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_RSA_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() > 0;
    }

    @Override
    public boolean isDecryptor() {
        return this.privkey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pkeyCipherList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_RSA_OAEP_LOCAL_V0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pubkeyList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            RSAPkeyCipherV1 pkeyCipher = new RSAPkeyCipherV1(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = new RSAPkeyCipherV1(keypair);
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_RSA_OAEP_LOCAL_V1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = pkeyCipher;
    }

    @Override
    public byte[] envelopeSeal(byte[] plaintext, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            Keypair keypair = new Pkcs8KeyOperator().generate(KeyTypeEnum.KEY_RSA2048_PKCS8);
            secretKey = this.kdf(keypair.getPubkeyEncoded());
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            byte[] gcmCipherText = cipher.encrypt(plaintext);
            int pubkeyNr = this.pubkeyList.size();
            int skeyCipherLength = 262 * pubkeyNr;
            byte[] output = new byte[2 + skeyCipherLength + gcmCipherText.length];
            int index = 2;
            output[0] = (byte)(pubkeyNr >> 8 & 0xFF);
            output[1] = (byte)(pubkeyNr & 0xFF);
            for (PkeyCipherBase publicKey : this.pubkeyList) {
                byte[] encryptedSkey = publicKey.encrypt(secretKey);
                System.arraycopy(encryptedSkey, 0, output, index, encryptedSkey.length);
                index += encryptedSkey.length;
            }
            System.arraycopy(gcmCipherText, 0, output, index, gcmCipherText.length);
            return output;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] envelopeOpen(byte[] cipherText, byte[] secretKey) {
        if (!this.isDecryptor() && secretKey == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        if (cipherText == null || cipherText.length < 2) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text!");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            int pubkeyNr = ((cipherText[0] & 0xFF) << 8) + (cipherText[1] & 0xFF);
            if (pubkeyNr == 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key number!");
            }
            int index = 2;
            int start = 2 + pubkeyNr * 262;
            int aesCipherTextLen = cipherText.length - start;
            if (aesCipherTextLen <= 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text, need at least " + (start + 12 + 16 + 1) + "bytes");
            }
            byte[] aesCipherText = new byte[aesCipherTextLen];
            System.arraycopy(cipherText, start, aesCipherText, 0, aesCipherTextLen);
            if (secretKey == null) {
                for (int i = 0; i < pubkeyNr; ++i) {
                    try {
                        byte[] encryptedSkey = Arrays.copyOfRange(cipherText, index, index + 262);
                        index += 262;
                        secretKey = this.privkey.decrypt(encryptedSkey);
                        break;
                    }
                    catch (Exception e) {
                        if (i != pubkeyNr - 1) continue;
                        throw new MychainSdkException(ErrorCode.OTHERS, "no matching encrypted skey");
                    }
                }
            }
            if (secretKey == null || secretKey.length != 16) {
                throw new MychainSdkException(ErrorCode.OTHERS, "no matching encrypted skey");
            }
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            byte[] plainText = cipher.decrypt(aesCipherText);
            return plainText;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private byte[] kdf(byte[] input) {
        byte[] hash = HashFactory.getHash().hash(input);
        byte[] hash2 = Arrays.copyOfRange(hash, 16, 32);
        byte[] secretKey = new byte[16];
        for (int i = 0; i < 16; ++i) {
            secretKey[i] = (byte)(hash[i] ^ hash2[i]);
        }
        return secretKey;
    }

    public static void main(String[] args) {
        ArrayList<Keypair> keypairs = new ArrayList<Keypair>();
        Keypair keypair = new Keypair(Hex.decode((String)"000430820122300d06092a864886f70d01010105000382010f003082010a0282010100c727186ee5aab800c7ad32c056c0c1c67fd090a093b2f9a972fbed77be56e730871c7c49ac9915ba8bda03b1f692f35f94517083df652c06f4b55d2b27600dfca942998b869138b3988af5bfaa18850fcc90b78087df66f0d93548ea3e103ee9ed1825156ebf0d059904aeaeb88336ee0283dbe46a67d9b7d267e4c9e1707e280d760b1bbb5c95491f0a7393682e0bed5b33b4995989d497a123c60525bbfaff0129a8f8c64473b8ad09aa67ff966b8eda267a77447c975301a1b576539049643bd1a3fbe42f516a475a011b0fa6b9c2669c79150cac3a9542eaef0e1157b5466db0a4345ac5a97dd5b618017046b936ccd5f4af85f669a1aece4546f5ddef6d0203010001"), Hex.decode((String)"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"));
        Keypair keypair2 = new Keypair(Hex.decode((String)"000430820122300d06092a864886f70d01010105000382010f003082010a0282010100adad8d87c535d0edf55d08c069b918b679d1770190a0a93f4ac31a2ec7ec11d381bdd49c755c02e8b420e1b564a9ae6ffd45da79f1ab1d202dc8eaaf04cd66dc5dd552c50f57976b225a3f10082befd498c94f2f0f45c1173e80bbccada8aebdc2f01a92be8a705f91df4ebb5ef7149f203ed341183881d0b1ed3cc1d6307415113f6f142d6bc5303c18a4ae33fe66c5946bd7d0bcfdffb01887e3cc413870bebb4b74764badf8312ad1a559bc055bdd602ee9a0e050e4a0ee2b9cf521f02b1bf967d6875566e4504aea124dfa0ddefb6ba64277c5b8da8f93d42e4ffddff851184de200022eaf6341c6b1eb5b4778265962d3e5c506236ea60b126594d5c20f0203010001"), Hex.decode((String)"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"));
        keypairs.add(keypair);
        keypairs.add(keypair2);
        RSAEnvelopeV1 rsaEnvelopeV1 = new RSAEnvelopeV1();
        rsaEnvelopeV1.setPubkeyList(keypairs);
        rsaEnvelopeV1.setPrivkey(keypair);
        byte[] sealed = rsaEnvelopeV1.envelopeSeal(Hex.decode((String)"48656c6c6f20776f726c6421"), null);
        System.out.println(Hex.toHexString((byte[])sealed));
        byte[] plaintext = rsaEnvelopeV1.envelopeOpen(sealed, null);
        System.out.println(new String(plaintext));
    }
}

