/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.spv;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BlockReceiptInfo
extends MychainObject {
    private Hash blockHash;
    private List<TransactionReceipt> receipts;

    public BlockReceiptInfo(Hash blockHash, List<TransactionReceipt> receipts) {
        this.blockHash = blockHash;
        this.receipts = receipts;
    }

    public BlockReceiptInfo() {
    }

    public Hash getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(Hash blockHash) {
        this.blockHash = blockHash;
    }

    public List<TransactionReceipt> getReceipts() {
        return this.receipts;
    }

    public void setReceipts(List<TransactionReceipt> receipts) {
        this.receipts = receipts;
    }

    @Override
    public byte[] toRlp() {
        byte[] blockHashBytes = Rlp.encodeElement(this.blockHash.getValue());
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (TransactionReceipt item : this.receipts) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(blockHashBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        this.blockHash = new Hash(((RlpElement)list.get(0)).getRlpData());
        this.receipts = new ArrayList<TransactionReceipt>();
        RlpList data = (RlpList)list.get(1);
        for (RlpElement element : data) {
            TransactionReceipt item = new TransactionReceipt();
            item.fromRlp((RlpList)element);
            this.receipts.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("block_hash", (Object)ByteUtils.toHexString(this.blockHash.getValue()));
        JSONArray jsonArray = new JSONArray();
        if (this.receipts != null) {
            for (TransactionReceipt item : this.receipts) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("receipts", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.blockHash = new Hash(jsonObject.getString("block_hash"));
        this.receipts = new ArrayList<TransactionReceipt>();
        JSONArray jsonArray = jsonObject.getJSONArray("receipts");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                TransactionReceipt object = new TransactionReceipt();
                object.fromJson((JSONObject)iterator.next());
                this.receipts.add(object);
            }
        }
    }
}

