/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.transaction;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class TransactionInfo
extends MychainObject {
    private Transaction transaction = new Transaction();
    private TransactionReceipt transactionReceipt = new TransactionReceipt();
    private BigInteger blockNumber = BigInteger.ZERO;
    private int txIndex = 0;

    public TransactionInfo(Transaction transaction, TransactionReceipt transactionReceipt, BigInteger blockNumber, int txIndex) {
        this.transaction = transaction;
        this.transactionReceipt = transactionReceipt;
        this.blockNumber = blockNumber;
        this.txIndex = txIndex;
    }

    public TransactionInfo() {
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public TransactionReceipt getTransactionReceipt() {
        return this.transactionReceipt;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public void setTxIndex(int txIndex) {
        this.txIndex = txIndex;
    }

    @Override
    public byte[] toRlp() {
        byte[] txBytes = this.transaction.toRlp();
        byte[] receiptBytes = this.transactionReceipt.toRlp();
        byte[] numberBytes = Rlp.encodeBigInteger(this.blockNumber);
        byte[] indexBytes = Rlp.encodeInt(this.txIndex);
        return Rlp.encodeList(super.toRlp(), txBytes, receiptBytes, numberBytes, indexBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.transaction.fromRlp((RlpList)list.get(0));
        this.transactionReceipt.fromRlp((RlpList)list.get(1));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
        this.txIndex = ByteUtils.byteArrayToInt(((RlpElement)list.get(3)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONObject txObject = new JSONObject();
        this.transaction.toJson(txObject);
        jsonObject.put("transaction", (Object)txObject);
        JSONObject object = new JSONObject();
        this.transactionReceipt.toJson(object);
        jsonObject.put("receipt", (Object)object);
        jsonObject.put("block_number", (Object)this.getBlockNumber());
        jsonObject.put("transaction_index", (Object)this.getTxIndex());
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.transaction.fromJson(jsonObject.getJSONObject("transaction"));
        this.transactionReceipt.fromJson(jsonObject.getJSONObject("receipt"));
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.txIndex = jsonObject.getIntValue("transaction_index");
    }
}

