/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.message.MessageFactory;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class Message {
    private MessageType messageType;

    public Message(MessageType messageType) {
        this.messageType = messageType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public String toString() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg_name", (Object)MessageFactory.msgTypeToString(this.messageType));
        this.toJson(jsonObject);
        return jsonObject.toJSONString();
    }

    public byte[] toRlp() {
        byte[] msgTypeBytes = Rlp.encodeInt(this.messageType.getValue());
        return Rlp.encodeList(new byte[][]{msgTypeBytes});
    }

    public void fromRlp(RlpList list) {
        this.messageType = MessageType.valueOf(ByteUtils.byteArrayToInt(((RlpElement)list.get(0)).getRlpData()));
    }

    public void toJson(JSONObject jsonObject) {
        jsonObject.put("msg_type", (Object)this.messageType.getValue());
    }

    public void fromJson(JSONObject jsonObject) {
        this.messageType = MessageType.valueOf(jsonObject.getIntValue("msg_type"));
    }
}

