/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network.netty;

import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.network.netty.ITransport;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class BaseChannel {
    protected ILogger logger;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private ITransport transport;

    public BaseChannel(ILogger logger) {
        this.logger = logger;
    }

    public void start() {
        this.logger.info("channel start ...");
        try {
            this.transport.open();
        }
        catch (Exception e) {
            this.logger.error("channel start failed. e:{}", (Object)e.getMessage());
        }
    }

    public void stop() {
        this.logger.info("channel stop.");
        try {
            this.isRunning.set(false);
            if (this.transport != null) {
                this.transport.close();
            }
        }
        catch (Exception e) {
            this.logger.error("channel stop failed. e:{}", (Object)e.getMessage());
        }
    }

    public ITransport transport() {
        return this.transport;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void sendRequest(Object obj) {
        if (obj == null) {
            this.logger.error("obj is null.");
            return;
        }
        Channel channel = this.transport().channel();
        if (channel == null) {
            this.logger.error("channel is null.");
            return;
        }
        if (!channel.isActive()) {
            this.logger.error("channel is not active.");
            this.isRunning.set(false);
            return;
        }
        ChannelFuture sendFuture = channel.writeAndFlush(obj);
        sendFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) {
                if (future.isSuccess()) {
                    BaseChannel.this.logger.debug("Send request success.");
                } else {
                    BaseChannel.this.logger.error("Send request failed. cause:{}", (Object)ExceptionUtils.getStackTrace((Throwable)future.cause()));
                }
            }
        });
    }

    public boolean connect(InetSocketAddress address, int timeout) {
        if (this.transport().connect(address, timeout)) {
            this.isRunning.set(true);
            return true;
        }
        this.logger.debug("channel connect failed.");
        return false;
    }

    protected ITransport getTransport() {
        return this.transport;
    }

    public void setTransport(ITransport transport) {
        this.logger.info("set transport : " + transport.getClass().getName());
        this.transport = transport;
    }
}

