/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.utils;

import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.util.encoders.Hex;

public class ByteUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final String DEFAULT_CHARSET = "utf-8";
    private static final int HEX_BYTE_UINT = 2;
    private static final String HEX_STRING_PREFIX = "0x";

    public static byte[] longToBytes(long val) {
        return ByteBuffer.allocate(8).putLong(val).array();
    }

    public static byte[] intToBytesNoLeadZeroes(int val) {
        if (val == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        int len = 0;
        int tmpVal = val;
        while (tmpVal != 0) {
            tmpVal >>>= 8;
            ++len;
        }
        byte[] result = new byte[len];
        int index = result.length - 1;
        while (val != 0) {
            result[index] = (byte)(val & 0xFF);
            val >>>= 8;
            --index;
        }
        return result;
    }

    public static String toHexString(String data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        try {
            return Hex.toHexString((byte[])data.getBytes(DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new MychainSdkException(ErrorCode.SDK_UNSUPPORT_ENCODING_FAILED, ExceptionUtils.getStackTrace((Throwable)e), e);
        }
    }

    public static String toHexString(byte[] data) {
        return data == null ? "" : Hex.toHexString((byte[])data);
    }

    public static int byteArrayToInt(byte[] b) {
        if (b == null || b.length == 0) {
            return 0;
        }
        return new BigInteger(1, b).intValue();
    }

    public static long byteArrayToLong(byte[] b) {
        if (b == null || b.length == 0) {
            return 0L;
        }
        return new BigInteger(1, b).longValue();
    }

    public static String nibblesToPrettyString(byte[] nibbles) {
        StringBuilder builder = new StringBuilder();
        for (byte nibble : nibbles) {
            String nibbleString = ByteUtils.oneByteToHexString(nibble);
            builder.append("\\x").append(nibbleString);
        }
        return builder.toString();
    }

    public static String oneByteToHexString(byte value) {
        String retVal = Integer.toString(value & 0xFF, 16);
        if (retVal.length() == 1) {
            retVal = "0" + retVal;
        }
        return retVal;
    }

    public static byte[] and(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            throw new RuntimeException("Array sizes differ");
        }
        byte[] ret = new byte[b1.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(b1[i] & b2[i]);
        }
        return ret;
    }

    public static boolean isNullOrZeroArray(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isSingleZero(byte[] array) {
        return array.length == 1 && array[0] == 0;
    }

    public static int length(byte[] ... bytes) {
        int result = 0;
        for (byte[] array : bytes) {
            result += array == null ? 0 : array.length;
        }
        return result;
    }

    public static byte[] hexStringToBytes(String data) {
        if (data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        if (data.startsWith(HEX_STRING_PREFIX)) {
            data = data.substring(2);
        }
        if (data.length() % 2 == 1) {
            data = "0" + data;
        }
        return Hex.decode((String)data);
    }

    public static byte[] intToBytes(int val) {
        return ByteBuffer.allocate(4).putInt(val).array();
    }

    public static Integer bytesToInt(byte[] byteArr) {
        return ByteUtils.byteArrayToInt(byteArr);
    }

    public static byte[] intsToBytes(int[] arr, boolean bigEndian) {
        byte[] ret = new byte[arr.length * 4];
        ByteUtils.intsToBytes(arr, ret, bigEndian);
        return ret;
    }

    public static int[] bytesToInts(byte[] arr, boolean bigEndian) {
        int[] ret = new int[arr.length / 4];
        ByteUtils.bytesToInts(arr, ret, bigEndian);
        return ret;
    }

    public static void bytesToInts(byte[] b, int[] arr, boolean bigEndian) {
        if (!bigEndian) {
            int off = 0;
            for (int i = 0; i < arr.length; ++i) {
                int ii = b[off++] & 0xFF;
                ii |= b[off++] << 8 & 0xFF00;
                ii |= b[off++] << 16 & 0xFF0000;
                arr[i] = ii |= b[off++] << 24;
            }
        } else {
            int off = 0;
            for (int i = 0; i < arr.length; ++i) {
                int ii = b[off++] << 24;
                ii |= b[off++] << 16 & 0xFF0000;
                ii |= b[off++] << 8 & 0xFF00;
                arr[i] = ii |= b[off++] & 0xFF;
            }
        }
    }

    public static void intsToBytes(int[] arr, byte[] b, boolean bigEndian) {
        if (!bigEndian) {
            int off = 0;
            for (int i = 0; i < arr.length; ++i) {
                int ii = arr[i];
                b[off++] = (byte)(ii & 0xFF);
                b[off++] = (byte)(ii >> 8 & 0xFF);
                b[off++] = (byte)(ii >> 16 & 0xFF);
                b[off++] = (byte)(ii >> 24 & 0xFF);
            }
        } else {
            int off = 0;
            for (int i = 0; i < arr.length; ++i) {
                int ii = arr[i];
                b[off++] = (byte)(ii >> 24 & 0xFF);
                b[off++] = (byte)(ii >> 16 & 0xFF);
                b[off++] = (byte)(ii >> 8 & 0xFF);
                b[off++] = (byte)(ii & 0xFF);
            }
        }
    }

    public static Short bytesToShort(byte[] b) {
        if (b == null || b.length == 0) {
            return (short)0;
        }
        return new BigInteger(1, b).shortValue();
    }

    public static String byteArrayToString(byte[] paramBytes) {
        try {
            String paramStr = null;
            Charset charset = Charset.forName(DEFAULT_CHARSET);
            if (paramBytes != null) {
                paramStr = new String(paramBytes, charset);
            }
            return paramStr;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_BYTES_OPERATE_FAILED, ExceptionUtils.getStackTrace((Throwable)e), e);
        }
    }

    public static BigInteger byteArrayToBigInteger(byte[] b) {
        if (b == null || b.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(1, b);
    }

    public static byte[] stringToByteArray(String string) {
        if (string == null || string.isEmpty()) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        try {
            return string.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new MychainSdkException(ErrorCode.SDK_UNSUPPORT_ENCODING_FAILED, ExceptionUtils.getStackTrace((Throwable)e), e);
        }
    }

    public static byte[] booleanToBytes(boolean bool) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        byte b = (byte)(bool ? 1 : 0);
        byteBuffer.put(b);
        return byteBuffer.array();
    }

    public static String convertPublicKeyToFixedHexString(BigInteger key) {
        return ByteUtils.convertToFixedHexString(key, 130, 128);
    }

    public static String convertToFixedHexString(BigInteger key, int totalLength, int expectedLength) {
        try {
            byte zero = 48;
            if (key == null) {
                return null;
            }
            String hexString = ByteUtils.toHexString(key.toByteArray());
            byte[] src = hexString.getBytes();
            byte[] dest = new byte[expectedLength];
            if (src.length == totalLength) {
                if (src[0] == zero && src[1] == zero) {
                    System.arraycopy(src, 2, dest, 0, expectedLength);
                }
            } else if (src.length > expectedLength) {
                System.arraycopy(src, 0, dest, 0, expectedLength);
            } else {
                for (int i = 0; i < expectedLength - src.length; ++i) {
                    dest[i] = 48;
                }
                System.arraycopy(src, 0, dest, expectedLength - src.length, src.length);
            }
            return new String(dest);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_CONVERT_PUBLIC_KEY_FAILED, "failed to fix hex string");
        }
    }
}

