/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.spv;

import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.service.spv.SpvImp;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.spv.QueryBlockHeaderInfosRequest;
import com.alipay.mychain.sdk.message.spv.QueryBlockHeaderInfosResponse;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import java.math.BigInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SpvTask
extends AbstractTask {
    private INetwork network;
    private SpvImp spvImp;
    private volatile BigInteger blockNum;
    private Integer blockAmount;
    private Integer timeout;
    private volatile Boolean inProcess = Boolean.FALSE;

    public SpvTask(SpvImp spvImp, INetwork network, ILogger logger, BigInteger blockNum, Integer blockAmount, Integer intervalMs, Integer timeout) {
        super(intervalMs, TaskType.ALWAYS, logger);
        this.network = network;
        this.spvImp = spvImp;
        this.blockNum = blockNum;
        this.blockAmount = blockAmount;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        if (this.spvImp == null || this.network == null) {
            return;
        }
        BigInteger startBlockNum = this.blockNum.add(BigInteger.ONE);
        this.network.sendAsyncRequest((Request)new QueryBlockHeaderInfosRequest(startBlockNum, this.blockAmount.longValue()), new Hash(), new IAsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(int errorCode, Response response) {
                if (ErrorCode.SUCCESS.getErrorCode() != errorCode) {
                    return;
                }
                if (ErrorCode.SUCCESS != response.getErrorCode()) {
                    return;
                }
                QueryBlockHeaderInfosResponse queryResponse = (QueryBlockHeaderInfosResponse)response;
                if (queryResponse.getBlockHeaderInfoList() == null || queryResponse.getBlockHeaderInfoList().isEmpty()) {
                    return;
                }
                1 var4_4 = this;
                synchronized (var4_4) {
                    if (SpvTask.this.inProcess.booleanValue()) {
                        return;
                    }
                    SpvTask.this.inProcess = true;
                    if (!queryResponse.getBlockHeaderInfoList().get(0).getBlockHeader().getNumber().equals(SpvTask.this.blockNum.add(BigInteger.ONE))) {
                        SpvTask.this.inProcess = false;
                        return;
                    }
                }
                try {
                    SpvTask.this.blockNum = BigInteger.valueOf(SpvTask.this.spvImp.verifyBlocks(SpvTask.this.blockNum.longValue(), queryResponse.getBlockHeaderInfoList()));
                }
                catch (Throwable cause) {
                    SpvTask.this.logger.error("SpvTask exception, cause: {}\n{}", (Object)cause.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)cause));
                }
                SpvTask.this.inProcess = false;
            }
        }, this.timeout.intValue());
    }
}

