/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.task;

import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.callback.IProcessBlockHandler;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.service.EventService;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.domain.event.EventTopicResult;
import com.alipay.mychain.sdk.domain.transaction.LogEntry;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.event.PushTopicsEvent;
import com.alipay.mychain.sdk.message.query.QueryBlockTxReceiptsRequest;
import com.alipay.mychain.sdk.message.query.QueryBlockTxReceiptsResponse;
import com.alipay.mychain.sdk.message.query.QueryLastBlockHeaderRequest;
import com.alipay.mychain.sdk.message.query.QueryLastBlockHeaderResponse;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReliableEventTask
extends AbstractTask {
    private INetwork network;
    private IEventCallback handler;
    private IProcessBlockHandler processBlockHandler;
    private Set<String> filteredTopics;

    public ReliableEventTask(INetwork network, IEventCallback handler, IProcessBlockHandler processBlockHandler, List<String> topics, VMTypeEnum vmTypeEnum, Boolean isPlainTopic, Integer interval, ILogger logger) {
        super(interval, TaskType.ALWAYS, logger);
        this.network = network;
        this.handler = handler;
        this.processBlockHandler = processBlockHandler;
        this.filteredTopics = this.contructFilterTopics(topics, vmTypeEnum, isPlainTopic);
    }

    @Override
    public void run() {
        BigInteger lastProcessedBlockNumber = this.processBlockHandler.getProcessedBlock();
        QueryLastBlockHeaderResponse queryLastBlockHeaderResponse = (QueryLastBlockHeaderResponse)this.network.sendSyncRequest((Request)new QueryLastBlockHeaderRequest(), new Hash(), 1000);
        BigInteger lastChainBlockNumber = queryLastBlockHeaderResponse.getHeader().getNumber();
        if (lastChainBlockNumber.compareTo(lastProcessedBlockNumber) <= 0) {
            return;
        }
        BigInteger start = lastProcessedBlockNumber.add(BigInteger.ONE);
        BigInteger end = lastChainBlockNumber.subtract(lastProcessedBlockNumber).compareTo(BigInteger.valueOf(100L)) > 0 ? lastProcessedBlockNumber.add(BigInteger.valueOf(100L)) : lastChainBlockNumber;
        ArrayList<EventTopicResult> results = new ArrayList<EventTopicResult>();
        while (start.compareTo(end) <= 0) {
            QueryBlockTxReceiptsResponse queryBlockTxReceiptsResponse = (QueryBlockTxReceiptsResponse)this.network.sendSyncRequest((Request)new QueryBlockTxReceiptsRequest(start), new Hash(), 3000);
            List<TransactionReceipt> transactionReceipts = queryBlockTxReceiptsResponse.getBlockInfo().getReceiptList();
            List<Hash> hashes = queryBlockTxReceiptsResponse.getBlockInfo().getTxHashs();
            for (int i = 0; i < transactionReceipts.size(); ++i) {
                TransactionReceipt transactionReceipt = transactionReceipts.get(i);
                List<LogEntry> logEntries = transactionReceipt.getLogs();
                for (LogEntry logEntry : logEntries) {
                    List<String> realTopics = logEntry.getTopics();
                    for (String topic : realTopics) {
                        if (!this.filteredTopics.contains(topic)) continue;
                        EventTopicResult eventTopicResult = new EventTopicResult(topic, logEntry.getLogData(), logEntry.getTo(), hashes.get(i));
                        results.add(eventTopicResult);
                    }
                }
            }
            start = start.add(BigInteger.ONE);
        }
        if (results.size() > 0) {
            PushTopicsEvent pushTopicsEvent = new PushTopicsEvent(BigInteger.valueOf(1L), results);
            this.handler.onEvent(pushTopicsEvent);
        }
        this.processBlockHandler.updateProcessedBlock(end);
    }

    private Set<String> contructFilterTopics(List<String> topics, VMTypeEnum vmType, Boolean isPlaintTopic) {
        HashSet<String> filteredTopics;
        block9: {
            block10: {
                block8: {
                    filteredTopics = new HashSet<String>();
                    if (!isPlaintTopic.booleanValue()) break block8;
                    for (String topic : topics) {
                        if (EventService.getTOPICS().contains(topic)) {
                            filteredTopics.add(topic);
                            continue;
                        }
                        try {
                            filteredTopics.add(ByteUtils.toHexString(topic.getBytes("iso-8859-1")));
                        }
                        catch (Exception e) {
                            MychainSdkException.throwInvalidParameters(e.getMessage());
                        }
                    }
                    break block9;
                }
                if (VMTypeEnum.EVM.getCode() != vmType.getCode()) break block10;
                for (String topic : topics) {
                    if (EventService.getTOPICS().contains(topic)) {
                        filteredTopics.add(topic);
                        continue;
                    }
                    filteredTopics.add(ByteUtils.toHexString(HashFactory.getHash(HashTypeEnum.Keccak).hash(ByteUtils.stringToByteArray(topic))));
                }
                break block9;
            }
            if (VMTypeEnum.WASM.getCode() != vmType.getCode()) break block9;
            for (String topic : topics) {
                if (EventService.getTOPICS().contains(topic)) {
                    filteredTopics.add(topic);
                    continue;
                }
                filteredTopics.add(ByteUtils.toHexString(topic));
            }
        }
        return filteredTopics;
    }
}

