/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class GasWithHold {
    private Identity withHoldId;
    private List<byte[]> sigs;

    public GasWithHold(Identity withHoldId, List<byte[]> sigs) {
        this.withHoldId = withHoldId;
        this.sigs = sigs;
    }

    public Identity getWithHoldId() {
        return this.withHoldId;
    }

    public void setWithHoldId(Identity withHoldId) {
        this.withHoldId = withHoldId;
    }

    public List<byte[]> getSigs() {
        return this.sigs;
    }

    public void setSigs(List<byte[]> sigs) {
        this.sigs = sigs;
    }

    public byte[] toRlp() {
        byte[] withHoldIdBytes = Rlp.encodeElement(this.withHoldId.getData());
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (byte[] sig : this.sigs) {
            data.add(Rlp.encodeElement(sig));
        }
        return Rlp.encodeList(withHoldIdBytes, Rlp.encodeList(data));
    }

    public void fromRlp(RlpList list) {
        Identity withhold = new Identity(((RlpElement)list.get(0)).getRlpData());
        RlpList list1 = (RlpList)list.get(1);
        this.sigs = new ArrayList<byte[]>();
        for (RlpElement rlpElement : list1) {
            this.sigs.add(rlpElement.getRlpData());
        }
    }

    public void toJson(JSONObject jsonObject) {
        jsonObject.put("with_hold", (Object)this.withHoldId.getValue());
        JSONArray jsonArray = new JSONArray();
        if (this.sigs != null) {
            for (byte[] sig : this.sigs) {
                jsonArray.add((Object)ByteUtils.toHexString(sig));
            }
        }
        jsonObject.put("sigs", (Object)jsonArray);
    }

    public void fromJson(JSONObject jsonObject) {
        this.withHoldId = new Identity(jsonObject.getBytes("with_hold"));
        JSONArray jsonArray = jsonObject.getJSONArray("sigs");
        this.sigs = new ArrayList<byte[]>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                this.sigs.add(Hex.decode((String)jsonArray.getString(i)));
            }
        }
    }

    public static byte[] createGasWithHold(Hash hash, Identity identity, List<SignerBase> signerBases) {
        ArrayList<byte[]> sigs = new ArrayList<byte[]>();
        for (SignerBase signerBase : signerBases) {
            sigs.add(signerBase.sign(hash.getData()));
        }
        GasWithHold gasWithHold = new GasWithHold(identity, sigs);
        return gasWithHold.toRlp();
    }
}

