/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto;

import com.alipay.mychain.sdk.crypto.Type;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class PublicKey
implements Type<byte[]>,
Serializable {
    public static final int LENGTH = 512;
    public static final int LENGTH_BYTE = 64;
    public static final int LENGTH_ENCODED = 67;
    private static final long serialVersionUID = -8024866317211814632L;
    private byte[] data;

    public PublicKey() {
        this.data = new byte[64];
        Arrays.fill(this.data, (byte)0);
    }

    public PublicKey(Keypair keypair) {
        if (!keypair.isPubkey()) {
            throw new IllegalArgumentException(" public key is empty!");
        }
        this.data = keypair.getType() == KeyTypeEnum.KEY_ECCK1_PKCS8 ? Arrays.copyOfRange(keypair.getPubkeyId(), keypair.getPubkeyId().length - 64, keypair.getPubkeyId().length) : ArrayUtils.clone((byte[])keypair.getPubkeyEncoded());
    }

    public PublicKey(byte[] value) {
        this.data = ArrayUtils.clone((byte[])value);
    }

    public PublicKey(String hexString) {
        byte[] value = ByteUtils.hexStringToBytes(hexString);
        this.data = ArrayUtils.clone((byte[])value);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] value) {
        if (value.length != 64 && value.length != 67) {
            throw new IllegalArgumentException(" publicKey length invalidate!");
        }
        this.data = ArrayUtils.clone((byte[])value);
    }

    public String hexStrValue() {
        return ByteUtils.toHexString(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKey publicKey = (PublicKey)o;
        return Arrays.equals(this.data, publicKey.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return this.hexStrValue();
    }

    @Override
    public byte[] getValue() {
        return this.data;
    }
}

