/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.SM4CbcPkeyCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.crypto.pkeycipher.SM2PkeyCipherV1;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;

public class SM2EnvelopSGX
implements EnvelopeBase {
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase privkey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_SM2_LOCAL_SGX;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() > 0;
    }

    @Override
    public boolean isDecryptor() {
        return this.privkey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_SM2_LOCAL_V1) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            SM2PkeyCipherV1 pkeyCipher = new SM2PkeyCipherV1(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = new SM2PkeyCipherV1(keypair);
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_SM2_LOCAL_V1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = pkeyCipher;
    }

    @Override
    public byte[] envelopeSeal(byte[] plaintext, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys");
        }
        byte[] userkey = new byte[16];
        if (secretKey != null) {
            System.arraycopy(secretKey, 0, userkey, 0, secretKey.length);
        }
        SM4CbcPkeyCipherV1 sm4CbcPkeyCipherV1 = new SM4CbcPkeyCipherV1(userkey);
        byte[] hmacKey = HashFactory.getHash(HashTypeEnum.SM3).hash(userkey);
        byte[] realHmacKey = new byte[16];
        System.arraycopy(hmacKey, 0, realHmacKey, 0, 16);
        KeyParameter keyParameter = new KeyParameter(realHmacKey);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(plaintext, 0, plaintext.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        byte[] hmacWithTx = new byte[32 + plaintext.length];
        System.arraycopy(result, 0, hmacWithTx, 0, 32);
        System.arraycopy(plaintext, 0, hmacWithTx, 32, plaintext.length);
        byte[] ciphertextSm4 = sm4CbcPkeyCipherV1.encrypt(hmacWithTx);
        int publicKeyNr = this.pubkeyList.size();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write((byte)(publicKeyNr & 3));
        byteArrayOutputStream.write(32);
        int index = 2;
        for (PkeyCipherBase publicKey : this.pubkeyList) {
            byte[] encryptedSkey = publicKey.encrypt(userkey);
            byteArrayOutputStream.write(encryptedSkey, 6, encryptedSkey.length - 6);
        }
        byteArrayOutputStream.write(ciphertextSm4, 2, ciphertextSm4.length - 2);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] envelopeOpen(byte[] ciphertext, byte[] secretKey) {
        int count = ciphertext[0] & 3;
        if (count != 1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid ciphertext public key length");
        }
        if (ciphertext[1] != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid ciphertext");
        }
        int offset = 2;
        ArrayList<byte[]> encryptedSkeyList = new ArrayList<byte[]>();
        for (int i = 0; i < count; ++i) {
            int length = ciphertext[offset + 1] & 0xFF;
            byte[] encryptedSkey = new byte[8 + length];
            System.arraycopy(AlgoIdEnum.PKEY_CIPHER_SM2_LOCAL_V1.toBytes(), 0, encryptedSkey, 0, 2);
            System.arraycopy(ciphertext, offset, encryptedSkey, 6, 2 + length);
            encryptedSkeyList.add(encryptedSkey);
            offset += 2 + length;
        }
        byte[] encrypted = new byte[ciphertext.length - offset];
        System.arraycopy(ciphertext, offset, encrypted, 0, ciphertext.length - offset);
        byte[] sm4ciphetext = new byte[encrypted.length + 2];
        System.arraycopy(AlgoIdEnum.CIPHER_SM4_CBC_LOCAL_V1.toBytes(), 0, sm4ciphetext, 0, 2);
        System.arraycopy(encrypted, 0, sm4ciphetext, 2, encrypted.length);
        if (secretKey != null) {
            byte[] userkey = new byte[16];
            if (secretKey != null) {
                System.arraycopy(secretKey, 0, userkey, 0, secretKey.length);
            }
            byte[] txData = this.valid(userkey, sm4ciphetext);
            return txData;
        }
        byte[] decryptedUserKey = null;
        for (byte[] encryptedSkey : encryptedSkeyList) {
            decryptedUserKey = this.privkey.decrypt(encryptedSkey);
        }
        Object txData = this.valid(decryptedUserKey, sm4ciphetext);
        return txData;
    }

    private byte[] valid(byte[] userkey, byte[] sm4ciphetext) {
        SM4CbcPkeyCipherV1 sm4CbcPkeyCipherV1 = new SM4CbcPkeyCipherV1(userkey);
        byte[] hmacWithTx = sm4CbcPkeyCipherV1.decrypt(sm4ciphetext);
        byte[] txData = new byte[hmacWithTx.length - 32];
        System.arraycopy(hmacWithTx, 32, txData, 0, txData.length);
        byte[] hmacKey = HashFactory.getHash(HashTypeEnum.SM3).hash(userkey);
        byte[] realHmacKey = new byte[16];
        System.arraycopy(hmacKey, 0, realHmacKey, 0, 16);
        KeyParameter keyParameter = new KeyParameter(realHmacKey);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(txData, 0, txData.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        for (int i = 0; i < 32; ++i) {
            if (result[i] == hmacWithTx[i]) continue;
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "mac not matched");
        }
        return txData;
    }

    public static void main(String[] args) {
        Keypair keypair = new Keypair(Hex.decode((String)"000304eb30c7f3b9f5040f4b312808243a3701e0aacca8e8edc47cbbccaac2bb74f18f95db638f00161f7f599c10baa06086305fa5505d386816f18d20e79bc72a579a"), Hex.decode((String)"0003d63953535f94f45a31411d58e2f5e1acd5b7dc9fa0bed291722e8d534de0b45c"));
        SM2PkeyCipherV1 sm2PkeyCipherV1 = new SM2PkeyCipherV1(keypair);
        ArrayList<PkeyCipherBase> list = new ArrayList<PkeyCipherBase>();
        list.add(sm2PkeyCipherV1);
        SM2EnvelopSGX sm2EnvelopSGX = new SM2EnvelopSGX();
        sm2EnvelopSGX.setPkeyCipherList(list);
        sm2EnvelopSGX.setPrivkey(sm2PkeyCipherV1);
        byte[] sm4 = sm2EnvelopSGX.envelopeSeal(Hex.decode((String)"7f15db08b8f9c3d8d6601091dfaa986285e52faa2a88f9a27f7ec44f5012e11868656c6c6f20776f726c64"), Hex.decode((String)"aafb784a6e1eae15f789d510c5fb743a"));
        byte[] plaintext = sm2EnvelopSGX.envelopeOpen(sm4, null);
        System.out.println(Hex.toHexString((byte[])plaintext));
    }
}

