/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.SM4CbcPkeyCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.crypto.pkeycipher.SM2PkeyCipherV1;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2EnvelopeV1
implements EnvelopeBase {
    private static final int SM4_128_BLOCK_SIZE = 16;
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase privkey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_SM2_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() > 0;
    }

    @Override
    public boolean isDecryptor() {
        return this.privkey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pkeyCipherList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_SM2_LOCAL_V1) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pubkeyList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            SM2PkeyCipherV1 pkeyCipher = new SM2PkeyCipherV1(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = new SM2PkeyCipherV1(keypair);
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_SM2_LOCAL_V1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = pkeyCipher;
    }

    @Override
    public byte[] envelopeSeal(byte[] plaintext, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Random rnd = new Random();
            if (secretKey == null) {
                secretKey = new byte[16];
                rnd.nextBytes(secretKey);
            }
            SM4CbcPkeyCipherV1 sm4CbcPkeyCipherV1 = new SM4CbcPkeyCipherV1(secretKey);
            byte[] sm4CipherText = sm4CbcPkeyCipherV1.encrypt(plaintext);
            int pubkeyNr = this.pubkeyList.size();
            int totalSize = 2;
            ArrayList<byte[]> sealSkeys = new ArrayList<byte[]>();
            for (PkeyCipherBase publicKey : this.pubkeyList) {
                byte[] secretKeyEncrypted = publicKey.encrypt(secretKey);
                totalSize += secretKeyEncrypted.length;
                sealSkeys.add(secretKeyEncrypted);
            }
            byte[] output = new byte[totalSize += sm4CipherText.length];
            int index = 0;
            output[index++] = (byte)(pubkeyNr >> 8 & 0xFF);
            output[index++] = (byte)(pubkeyNr & 0xFF);
            for (byte[] sealSkey : sealSkeys) {
                System.arraycopy(sealSkey, 0, output, index, sealSkey.length);
                index += sealSkey.length;
            }
            System.arraycopy(sm4CipherText, 0, output, index, sm4CipherText.length);
            return output;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] envelopeOpen(byte[] cipherText, byte[] secretKey) {
        if (!this.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        if (secretKey != null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "secret key provide by user not supported");
        }
        try {
            int pubkeyNr = ((cipherText[0] & 0xFF) << 8) + (cipherText[1] & 0xFF);
            if (pubkeyNr == 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key number!");
            }
            int index = 2;
            int sealKeyOffset = 9;
            int totalSealKeysLen = 0;
            if (secretKey == null) {
                for (int i = 0; i < pubkeyNr; ++i) {
                    byte leftPartLen = cipherText[sealKeyOffset];
                    sealKeyOffset += leftPartLen + 2 + 4 + 1 + 1;
                    int totalSealKeyLen = 8 + leftPartLen;
                    totalSealKeysLen += totalSealKeyLen;
                    byte[] secretKeyEncrypted = Arrays.copyOfRange(cipherText, index, index + totalSealKeyLen);
                    index += totalSealKeyLen;
                    try {
                        if (secretKey != null) continue;
                        byte[] tempPubkey = this.privkey.decrypt(secretKeyEncrypted);
                        secretKey = tempPubkey;
                        continue;
                    }
                    catch (Exception e) {
                        if (i != pubkeyNr - 1) continue;
                        throw e;
                    }
                }
            }
            SM4CbcPkeyCipherV1 sm4CbcPkeyCipherV1 = new SM4CbcPkeyCipherV1(secretKey);
            byte[] sm4CipherText = Arrays.copyOfRange(cipherText, 2 + totalSealKeysLen, cipherText.length);
            byte[] plainText = sm4CbcPkeyCipherV1.decrypt(sm4CipherText);
            return plainText;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

