/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.pkeycipher;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;

public class EccR1PkeyCipherV1
implements PkeyCipherBase {
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256r1");
    private static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    private static final int rLength = 68;
    private byte[] publicKey;
    private byte[] privateKey;

    public EccR1PkeyCipherV1(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_ECCR1_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            this.publicKey = ArrayUtils.clone((byte[])pubKey);
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            this.privateKey = ArrayUtils.clone((byte[])priKey);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.publicKey = this.getPubKeyByPrivkey(priKey);
            }
        }
    }

    public byte[] getPubKeyByPrivkey(byte[] privateKey) {
        BigInteger priKeyIn = new BigInteger(1, privateKey);
        ECPoint point = CryptoUtils.publicPointFromPrivate(CURVE, priKeyIn);
        return Arrays.copyOfRange(point.getEncoded(false), 0, 65);
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.PKEY_CIPHER_ECCR1_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return !ArrayUtils.isEmpty((byte[])this.publicKey) || !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public boolean isDecryptor() {
        return !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public byte[] encrypt(byte[] plaintext) {
        if (ArrayUtils.isEmpty((byte[])plaintext)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "plainText is empty");
        }
        if (plaintext.length > 255) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "plainText size more than 255!");
        }
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
        }
        Keypair keypair = new Pkcs8KeyOperator().generate(KeyTypeEnum.KEY_ECCR1_PKCS8);
        BigInteger k = new BigInteger(1, keypair.getPrivkeyId());
        ECPoint q = new SecP256R1Curve().createPoint(ByteUtils.byteArrayToBigInteger(Arrays.copyOfRange(this.publicKey, 1, 33)), ByteUtils.byteArrayToBigInteger(Arrays.copyOfRange(this.publicKey, 33, 65)));
        ECPoint r = q.multiply(k).normalize();
        byte[] kQ = r.getEncoded(false);
        if (kQ.length != 65 || kQ[0] != 4) {
            throw new MychainSdkException(ErrorCode.OTHERS, "kQ is not correct");
        }
        int payloadLen = plaintext.length;
        byte[] rawCiphertext = new byte[72 + payloadLen];
        rawCiphertext[0] = 48;
        rawCiphertext[1] = (byte)(70 + payloadLen);
        rawCiphertext[2] = 3;
        rawCiphertext[3] = 66;
        rawCiphertext[4] = 0;
        System.arraycopy(keypair.getPubkeyId(), 0, rawCiphertext, 5, keypair.getPubkeyId().length);
        rawCiphertext[70] = 4;
        rawCiphertext[71] = (byte)payloadLen;
        int count = payloadLen >> 5;
        int reminder = payloadLen & 0x1F;
        byte[] message = new byte[66];
        System.arraycopy(kQ, 0, message, 0, 65);
        for (int i = 0; i < count; ++i) {
            message[65] = (byte)i;
            byte[] mask = HashFactory.getHash().hash(message);
            for (int j = 0; j < 32; ++j) {
                rawCiphertext[72 + i * 32 + j] = (byte)(plaintext[i * 32 + j] ^ mask[j]);
            }
        }
        message[65] = (byte)count;
        byte[] mask = HashFactory.getHash().hash(message);
        for (int i = 0; i < reminder; ++i) {
            rawCiphertext[72 + count * 32 + i] = (byte)(plaintext[count * 32 + i] ^ mask[i]);
        }
        byte[] cipherText = new byte[6 + rawCiphertext.length];
        System.arraycopy(this.getAlgo().toBytes(), 0, cipherText, 0, 2);
        byte[] pubkeyWithAlgo = new byte[2 + this.publicKey.length];
        System.arraycopy(KeyTypeEnum.KEY_ECCR1_PKCS8.toBytes(), 0, pubkeyWithAlgo, 0, 2);
        System.arraycopy(this.publicKey, 0, pubkeyWithAlgo, 2, this.publicKey.length);
        System.arraycopy(CryptoUtils.getPubkeyFp(pubkeyWithAlgo), 0, cipherText, 2, 4);
        System.arraycopy(rawCiphertext, 0, cipherText, 6, rawCiphertext.length);
        return cipherText;
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        if (!this.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "no private key");
        }
        if (ArrayUtils.isEmpty((byte[])ciphertext)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "cipher text is null");
        }
        byte[] R = new byte[65];
        System.arraycopy(ciphertext, 11, R, 0, 65);
        ECPoint q = new SecP256R1Curve().createPoint(new BigInteger(1, Arrays.copyOfRange(R, 1, 33)), new BigInteger(1, Arrays.copyOfRange(R, 33, 65)));
        byte[] kQ = q.multiply(new BigInteger(1, this.privateKey)).normalize().getEncoded(false);
        if (kQ.length != 65) {
            throw new MychainSdkException(ErrorCode.OTHERS, "kQ is not correct");
        }
        byte plainTextLength = ciphertext[77];
        byte[] plainText = new byte[plainTextLength];
        int count = plainTextLength >> 5;
        int reminder = plainTextLength & 0x1F;
        byte[] message = new byte[66];
        System.arraycopy(kQ, 0, message, 0, 65);
        for (int i = 0; i < count; ++i) {
            message[65] = (byte)i;
            byte[] mask = HashFactory.getHash().hash(message);
            for (int j = 0; j < 32; ++j) {
                plainText[i * 32 + j] = (byte)(ciphertext[78 + i * 32 + j] ^ mask[j]);
            }
        }
        message[65] = (byte)count;
        byte[] mask = HashFactory.getHash().hash(message);
        for (int i = 0; i < reminder; ++i) {
            plainText[count * 32 + i] = (byte)(ciphertext[78 + count * 32 + i] ^ mask[i]);
        }
        return plainText;
    }
}

