/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.pkeycipher;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;

public class SM2PkeyCipherV1
implements PkeyCipherBase {
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"sm2p256v1");
    private static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    private byte[] privateKey;
    private byte[] publicKey;

    public SM2PkeyCipherV1(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            this.publicKey = ArrayUtils.clone((byte[])pubKey);
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            this.privateKey = ArrayUtils.clone((byte[])priKey);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.publicKey = this.getPubKeyByPrivkey(priKey);
            }
        }
    }

    private static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3) throws Exception {
        int c1Len = (CURVE_PARAMS.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] c1 = new byte[65];
        System.arraycopy(c1c2c3, 0, c1, 0, 65);
        byte[] c2 = new byte[c1c2c3.length - 65 - 32];
        System.arraycopy(c1c2c3, 65, c2, 0, c1c2c3.length - 65 - 32);
        byte[] c3 = new byte[32];
        System.arraycopy(c1c2c3, c1c2c3.length - 32, c3, 0, 32);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(Arrays.copyOfRange(c1, 1, 33)));
        v.add((ASN1Encodable)new ASN1Integer(Arrays.copyOfRange(c1, 33, 65)));
        v.add((ASN1Encodable)new DEROctetString(c3));
        v.add((ASN1Encodable)new DEROctetString(c2));
        DERSequence derSequence = new DERSequence(v);
        return derSequence.getEncoded();
    }

    private static byte[] changeC1C3C2toC1C2C3(byte[] c1c3c2) throws Exception {
        DLSequence dlsSequence = (DLSequence)DERSequence.fromByteArray((byte[])c1c3c2);
        byte[] c2 = ((ASN1OctetString)dlsSequence.getObjectAt(3)).getOctets();
        byte[] c1c2c3 = new byte[65 + c2.length + 32];
        c1c2c3[0] = 4;
        System.arraycopy(((ASN1Integer)dlsSequence.getObjectAt(0)).getValue().toByteArray(), 0, c1c2c3, 1, 32);
        System.arraycopy(((ASN1Integer)dlsSequence.getObjectAt(1)).getValue().toByteArray(), 0, c1c2c3, 33, 32);
        System.arraycopy(c2, 0, c1c2c3, 65, c2.length);
        System.arraycopy(((ASN1OctetString)dlsSequence.getObjectAt(2)).getOctets(), 0, c1c2c3, c1c2c3.length - 32, 32);
        return c1c2c3;
    }

    public byte[] getPubKeyByPrivkey(byte[] privateKey) {
        BigInteger priKeyIn = new BigInteger(1, privateKey);
        ECPoint point = CryptoUtils.publicPointFromPrivate(CURVE, priKeyIn);
        return Arrays.copyOfRange(point.getEncoded(false), 0, 65);
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.PKEY_CIPHER_SM2_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return !ArrayUtils.isEmpty((byte[])this.publicKey) || !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public boolean isDecryptor() {
        return !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public byte[] encrypt(byte[] plaintext) {
        if (ArrayUtils.isEmpty((byte[])plaintext)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "plainText is empty");
        }
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
        }
        SM2Engine sm2Engine = new SM2Engine();
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(new SM2P256V1Curve().createPoint(new BigInteger(1, Arrays.copyOfRange(this.publicKey, 1, 33)), new BigInteger(1, Arrays.copyOfRange(this.publicKey, 33, 65))), CURVE);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
        try {
            byte[] rawCipherText = sm2Engine.processBlock(plaintext, 0, plaintext.length);
            rawCipherText = SM2PkeyCipherV1.changeC1C2C3ToC1C3C2(rawCipherText);
            byte[] cipherText = new byte[6 + rawCipherText.length];
            System.arraycopy(this.getAlgo().toBytes(), 0, cipherText, 0, 2);
            byte[] pubkeyWithAlgo = new byte[2 + this.publicKey.length];
            System.arraycopy(KeyTypeEnum.KEY_SM2_PKCS8.toBytes(), 0, pubkeyWithAlgo, 0, 2);
            System.arraycopy(this.publicKey, 0, pubkeyWithAlgo, 2, this.publicKey.length);
            System.arraycopy(CryptoUtils.getPubkeyFp(pubkeyWithAlgo), 0, cipherText, 2, 4);
            System.arraycopy(rawCipherText, 0, cipherText, 6, rawCipherText.length);
            return cipherText;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        if (ArrayUtils.isEmpty((byte[])ciphertext)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "message is empty");
        }
        if (!this.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.CRYPTO_ALGO_NOT_INIT, "private key is empty");
        }
        SM2Engine sm2Engine = new SM2Engine();
        ECPrivateKeyParameters ecPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger(1, this.privateKey), CURVE);
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        try {
            byte[] rawCiphertext = new byte[ciphertext.length - 6];
            System.arraycopy(ciphertext, 6, rawCiphertext, 0, rawCiphertext.length);
            byte[] c1c2c3 = SM2PkeyCipherV1.changeC1C3C2toC1C2C3(rawCiphertext);
            return sm2Engine.processBlock(c1c2c3, 0, c1c2c3.length);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

