/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.event;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class EventTopicResult
extends MychainObject {
    private String topic;
    private byte[] data;
    private Hash contractId;
    private Hash txHash;

    public EventTopicResult(String topic, byte[] data, Hash contractId, Hash txHash) {
        this.topic = topic;
        this.data = data;
        this.contractId = contractId;
        this.txHash = txHash;
    }

    public EventTopicResult() {
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Hash getContractId() {
        return this.contractId;
    }

    public void setContractId(Hash contractId) {
        this.contractId = contractId;
    }

    public Hash getTxHash() {
        return this.txHash;
    }

    public void setTxHash(Hash txHash) {
        this.txHash = txHash;
    }

    @Override
    public byte[] toRlp() {
        byte[] topicBytes = Rlp.encodeString(this.topic);
        byte[] dataBytes = Rlp.encodeElement(this.data);
        byte[] idBytes = Rlp.encodeElement(this.contractId.getValue());
        byte[] hashBytes = Rlp.encodeElement(this.txHash.getValue());
        return Rlp.encodeList(topicBytes, dataBytes, idBytes, hashBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.topic = ByteUtils.byteArrayToString(((RlpElement)list.get(0)).getRlpData());
        this.data = ((RlpElement)list.get(1)).getRlpData();
        this.contractId = new Hash(((RlpElement)list.get(2)).getRlpData());
        this.txHash = new Hash(((RlpElement)list.get(3)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("topic", (Object)this.topic);
        jsonObject.put("data", (Object)ByteUtils.toHexString(this.data));
        jsonObject.put("id", (Object)ByteUtils.toHexString(this.contractId.getValue()));
        jsonObject.put("tx_hash", (Object)ByteUtils.toHexString(this.txHash.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.topic = jsonObject.getString("topic");
        this.data = ByteUtils.hexStringToBytes(jsonObject.getString("data"));
        this.contractId = new Hash(jsonObject.getString("id"));
        this.txHash = new Hash(jsonObject.getString("tx_hash"));
    }
}

