/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.status.NodeInfo;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class HostStatus
extends MychainObject {
    private NodeInfo nodeInfo;
    private BigInteger latestBlockNumber;

    public HostStatus() {
    }

    public HostStatus(NodeInfo nodeInfo, BigInteger latestBlockNumber) {
        this.nodeInfo = nodeInfo;
        this.latestBlockNumber = latestBlockNumber;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public BigInteger getLatestBlockNumber() {
        return this.latestBlockNumber;
    }

    public void setLatestBlockNumber(BigInteger latestBlockNumber) {
        this.latestBlockNumber = latestBlockNumber;
    }

    @Override
    public void fromRlp(RlpList list) {
        this.nodeInfo = new NodeInfo();
        this.nodeInfo.fromRlp((RlpList)list.get(0));
        this.latestBlockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public byte[] toRlp() {
        byte[] nodeInfoBytes = this.nodeInfo.toRlp();
        byte[] latestBlockNumberBytes = Rlp.encodeBigInteger(this.latestBlockNumber);
        return Rlp.encodeList(nodeInfoBytes, latestBlockNumberBytes);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.nodeInfo = new NodeInfo();
        this.nodeInfo.fromJson((JSONObject)jsonObject.get((Object)"node_info"));
        this.latestBlockNumber = jsonObject.getBigInteger("latest_block_number");
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        JSONObject nodeInfoJsonObject = new JSONObject();
        this.nodeInfo.toJson(nodeInfoJsonObject);
        jsonObject.put("node_info", (Object)nodeInfoJsonObject);
        jsonObject.put("latest_block_number", (Object)this.latestBlockNumber);
    }
}

