/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.admin;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import org.apache.commons.lang3.ArrayUtils;

public class AddGroupChainRequest
extends Request {
    private Hash privateKey;

    public AddGroupChainRequest() {
        super(MessageType.MSG_TYPE_ADMIN_REQ_ADD_GROUP_CHAIN);
    }

    public AddGroupChainRequest(Hash privateKey) {
        super(MessageType.MSG_TYPE_ADMIN_REQ_ADD_GROUP_CHAIN);
        this.privateKey = privateKey;
    }

    public Hash getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(Hash privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.privateKey != null && ArrayUtils.isNotEmpty((byte[])this.privateKey.getValue());
    }

    @Override
    public byte[] toRlp() {
        byte[] privateKeyBytes = Rlp.encodeElement(this.privateKey.getValue());
        return Rlp.encodeList(super.toRlp(), privateKeyBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.privateKey = new Hash(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("private_key", (Object)ByteUtils.toHexString(this.privateKey.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.privateKey = new Hash(jsonObject.getString("private_key"));
    }
}

