/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.event.EventDataType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class FetchEventResponse
extends Response {
    private EventDataType type = EventDataType.Default;
    private byte[] data;

    public FetchEventResponse() {
        super(MessageType.MSG_TYPE_EVENT_RESP_FETCH);
    }

    public FetchEventResponse(EventDataType type, byte[] data) {
        super(MessageType.MSG_TYPE_EVENT_RESP_FETCH);
        this.type = type;
        this.data = data;
    }

    public EventDataType getType() {
        return this.type;
    }

    public void setType(EventDataType type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public byte[] toRlp() {
        byte[] typeBytes = Rlp.encodeInt(this.type.getCode());
        byte[] dataBytes = Rlp.encodeElement(this.data);
        return Rlp.encodeList(super.toRlp(), typeBytes, dataBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.type = EventDataType.valueOf(ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()));
        this.data = ((RlpElement)list.get(2)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("event_type", (Object)this.type.getCode());
        jsonObject.put("event_data", (Object)ByteUtils.toHexString(this.data));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.type = EventDataType.valueOf(jsonObject.getIntValue("event_type"));
        this.data = ByteUtils.hexStringToBytes(jsonObject.getString("event_data"));
    }
}

