/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.event.EventModelType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class ListenContractEventRequest
extends Request {
    private Identity id;
    private EventModelType type = EventModelType.PULL;

    public ListenContractEventRequest(Identity id, EventModelType type) {
        super(MessageType.MSG_TYPE_EVENT_REQ_CONTRACT);
        this.id = id;
        this.type = type;
    }

    public ListenContractEventRequest() {
        super(MessageType.MSG_TYPE_EVENT_REQ_CONTRACT);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.id != null && !this.id.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.type != null && (this.type.equals((Object)EventModelType.PULL) || this.type.equals((Object)EventModelType.PUSH));
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.MSG_TYPE_EVENT_REQ_CONTRACT;
    }

    public Identity getIdentity() {
        return this.id;
    }

    public void setIdentity(Identity id) {
        this.id = id;
    }

    public EventModelType getType() {
        return this.type;
    }

    public void setType(EventModelType type) {
        this.type = type;
    }

    @Override
    public byte[] toRlp() {
        byte[] typeBytes = Rlp.encodeInt(this.type.getCode());
        byte[] identityBytes = Rlp.encodeElement(this.id.getValue());
        return Rlp.encodeList(super.toRlp(), typeBytes, identityBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.type = EventModelType.valueOf(ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()));
        this.id = new Identity(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("event_type", (Object)this.type.getCode());
        jsonObject.put("id", (Object)ByteUtils.toHexString(this.id.getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.type = EventModelType.valueOf(jsonObject.getIntValue("event_type"));
        this.id = new Identity(jsonObject.getString("id"));
    }
}

