/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryBlockTxReceiptsRequest
extends Request {
    private BigInteger blockNumber = BigInteger.ZERO;

    public QueryBlockTxReceiptsRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_RECEIPTS_AND_HASH);
    }

    public QueryBlockTxReceiptsRequest(BigInteger blockNumber) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_RECEIPTS_AND_HASH);
        this.blockNumber = blockNumber;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.blockNumber != null && this.blockNumber.compareTo(BigInteger.ZERO) >= 0;
    }

    @Override
    public byte[] toRlp() {
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNumber);
        return Rlp.encodeList(super.toRlp(), blockNumberBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("block_number", (Object)this.blockNumber);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.blockNumber = jsonObject.getBigInteger("block_number");
    }
}

