/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.math.BigInteger;

public class DepositDataRequest
extends AbstractTransactionRequest {
    private Identity senderId;
    private Identity receiverId;
    private byte[] depositData;
    private BigInteger amount;

    public DepositDataRequest(Identity senderId, Identity receiverId, byte[] depositData, BigInteger amount) {
        super(MessageType.MSG_TYPE_TX_REQ_NATIVE_DEPOSIT_DATA);
        this.senderId = senderId;
        this.receiverId = receiverId;
        this.depositData = depositData;
        this.amount = amount;
    }

    public DepositDataRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_NATIVE_DEPOSIT_DATA);
    }

    public Identity getSenderId() {
        return this.senderId;
    }

    public Identity getReceiverId() {
        return this.receiverId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public byte[] getDepositData() {
        return this.depositData;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.senderId != null && !this.senderId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.receiverId != null && !this.receiverId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.depositData != null && this.amount != null;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_DEPOSIT_DATA);
        transaction.setFrom(this.senderId);
        transaction.setTo(this.receiverId);
        transaction.setData(this.depositData);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.amount));
        super.complete();
    }
}

