/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.math.BigInteger;

public class TransferBalanceRequest
extends AbstractTransactionRequest {
    private Identity id;
    private Identity receiverId;
    private BigInteger amount;

    public TransferBalanceRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_TRANS_BALANCE);
    }

    public TransferBalanceRequest(Identity id, Identity receiverId, BigInteger amount) {
        super(MessageType.MSG_TYPE_TX_REQ_TRANS_BALANCE);
        this.id = id;
        this.receiverId = receiverId;
        this.amount = amount;
    }

    public Identity getId() {
        return this.id;
    }

    public Identity getReceiverId() {
        return this.receiverId;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.id != null && !this.id.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.receiverId != null && !this.receiverId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.amount != null;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_TRANSFER_BALANCE);
        transaction.setFrom(this.id);
        transaction.setTo(this.receiverId);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.amount));
        super.complete();
    }
}

