/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.task;

import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import com.alipay.mychain.sdk.utils.ExecutorUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimerTaskManager {
    private Long currentTaskId = 0L;
    private Map<Long, Map<Integer, AbstractTask>> taskMap = new ConcurrentHashMap<Long, Map<Integer, AbstractTask>>();
    private ScheduledExecutorService executor = ExecutorUtils.getScheduledExecutorService("TimerTaskManager");

    public void startTimerTask() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    TimerTaskManager.this.processTask();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, 10L, 100L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.clearTask();
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTask() {
        ConcurrentHashMap<Long, Map<Integer, AbstractTask>> tasks;
        TimerTaskManager timerTaskManager = this;
        synchronized (timerTaskManager) {
            tasks = new ConcurrentHashMap<Long, Map<Integer, AbstractTask>>(this.taskMap);
        }
        for (Map.Entry entry : tasks.entrySet()) {
            AbstractTask task;
            Long taskId;
            block6: {
                taskId = (Long)entry.getKey();
                if (!this.isExist(taskId)) continue;
                task = (AbstractTask)((Map)entry.getValue()).values().iterator().next();
                if (System.currentTimeMillis() <= task.getNextTime()) continue;
                task.setNextTime(task.getNextTime() + (long)task.getInterval().intValue());
                try {
                    task.run();
                }
                catch (Throwable e) {
                    if (task.getLogger() == null) break block6;
                    task.getLogger().error(e.getMessage(), e);
                }
            }
            if (!task.getType().equals((Object)TaskType.ONCE)) continue;
            this.unRegisterTask(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerTask(AbstractTask task, TimerTaskType timerTaskType) {
        Long taskId;
        if (task == null) {
            return 0L;
        }
        TimerTaskManager timerTaskManager = this;
        synchronized (timerTaskManager) {
            TimerTaskManager timerTaskManager2 = this;
            Long l = timerTaskManager2.currentTaskId;
            Long l2 = timerTaskManager2.currentTaskId = Long.valueOf(timerTaskManager2.currentTaskId + 1L);
            taskId = l;
        }
        HashMap<Integer, AbstractTask> map = new HashMap<Integer, AbstractTask>();
        map.put(timerTaskType.ordinal(), task);
        this.taskMap.put(taskId, map);
        return taskId;
    }

    public void unRegisterTask(long taskId, TimerTaskType timerTaskType) {
        this.taskMap.remove(taskId);
    }

    public Long registerTask(AbstractTask task) {
        return this.registerTask(task, TimerTaskType.SYSTEM_TASK);
    }

    public void unRegisterTask(long taskId) {
        this.unRegisterTask(taskId, TimerTaskType.SYSTEM_TASK);
    }

    private boolean isExist(Long taskId) {
        return this.taskMap.containsKey(taskId);
    }

    private void clearTask() {
        this.taskMap.clear();
    }

    public AbstractTask getTaskByType(int taskType) {
        for (Map.Entry<Long, Map<Integer, AbstractTask>> entry : this.taskMap.entrySet()) {
            if (!entry.getValue().keySet().contains(taskType)) continue;
            return entry.getValue().get(taskType);
        }
        return null;
    }

    public static enum TimerTaskType {
        SYSTEM_TASK,
        ANCHOR_TASK;

    }
}

