/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.utils;

import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class VMUtils {
    public static byte[] encodeVMType(VMTypeEnum vmTypeEnum, byte[] vmCode) {
        if (vmCode != null) {
            byte[] encodedCode = new byte[vmCode.length + 1];
            if (vmTypeEnum == VMTypeEnum.EVM) {
                encodedCode[0] = 1;
            } else if (vmTypeEnum == VMTypeEnum.NATIVE) {
                encodedCode[0] = -1;
            } else if (vmTypeEnum == VMTypeEnum.WASM) {
                encodedCode[0] = 2;
            } else if (vmTypeEnum == VMTypeEnum.NATIVE_PRECOMPILE) {
                encodedCode[0] = -2;
            } else {
                return null;
            }
            System.arraycopy(vmCode, 0, encodedCode, 1, vmCode.length);
            return encodedCode;
        }
        return null;
    }

    public static VMTypeEnum decodeVMCode(byte[] vmCode) {
        if (vmCode != null) {
            if (vmCode[0] == 1) {
                return VMTypeEnum.EVM;
            }
            if (vmCode[0] == -1) {
                return VMTypeEnum.NATIVE;
            }
            if (vmCode[0] == 2) {
                return VMTypeEnum.WASM;
            }
            if (vmCode[0] == -2) {
                return VMTypeEnum.NATIVE_PRECOMPILE;
            }
        }
        return null;
    }

    public static byte[] constructDeployData(VMTypeEnum vmTypeEnum, byte[] vmCode, byte[] paraCode) {
        if (vmCode != null) {
            if (vmTypeEnum == VMTypeEnum.EVM) {
                int paraCodeLen = 0;
                if (paraCode != null) {
                    paraCodeLen = paraCode.length;
                }
                byte[] encodedCode = new byte[vmCode.length + 1 + paraCodeLen];
                encodedCode[0] = 1;
                System.arraycopy(vmCode, 0, encodedCode, 1, vmCode.length);
                if (paraCode != null) {
                    System.arraycopy(paraCode, 0, encodedCode, 1 + vmCode.length, paraCodeLen);
                }
                return encodedCode;
            }
            if (vmTypeEnum == VMTypeEnum.NATIVE) {
                byte[] encodedCode = new byte[vmCode.length + 1];
                encodedCode[0] = -1;
                System.arraycopy(vmCode, 0, encodedCode, 1, vmCode.length);
                return encodedCode;
            }
            if (vmTypeEnum == VMTypeEnum.WASM) {
                int paraCodeLength = 0;
                if (paraCode != null) {
                    paraCodeLength = paraCode.length;
                }
                int totalLength = 5 + vmCode.length + 4 + paraCodeLength;
                int flag = 2;
                byte[] codeLength = ByteUtils.intToBytes(vmCode.length);
                byte[] paraLength = ByteUtils.intToBytes(paraCodeLength);
                byte[] result = new byte[totalLength];
                result[0] = flag;
                System.arraycopy(codeLength, 0, result, 1, codeLength.length);
                System.arraycopy(vmCode, 0, result, 1 + codeLength.length, vmCode.length);
                System.arraycopy(paraLength, 0, result, 1 + codeLength.length + vmCode.length, paraLength.length);
                if (paraCode != null && paraCode.length > 0) {
                    System.arraycopy(paraCode, 0, result, 1 + codeLength.length + vmCode.length + paraLength.length, paraCode.length);
                }
                return result;
            }
            if (vmTypeEnum == VMTypeEnum.NATIVE_PRECOMPILE) {
                byte[] encodedCode = new byte[vmCode.length + 1];
                encodedCode[0] = -2;
                System.arraycopy(vmCode, 0, encodedCode, 1, vmCode.length);
                return encodedCode;
            }
            return null;
        }
        return null;
    }
}

