/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractIntType;
import java.math.BigInteger;

public class Int
extends AbstractIntType {
    public static final String TYPE_NAME = "int";
    public static final BigInteger MAX = BigInteger.valueOf(2L).pow(255);
    public static final BigInteger MAX_INT256 = MAX.subtract(BigInteger.ONE);
    public static final BigInteger MIN_INT256 = MAX.negate();
    public static final Int DEFAULT = new Int(BigInteger.ZERO);

    public Int(BigInteger value) {
        this(256, value);
    }

    protected Int(int bitSize, BigInteger value) {
        super(TYPE_NAME, bitSize, value);
        if (value.compareTo(MAX_INT256) > 0 || value.compareTo(MIN_INT256) < 0) {
            throw new UnsupportedOperationException("Int64 should not be greater than  2^255-1 and less than -2^255");
        }
    }
}

