/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.Int;
import java.math.BigInteger;

public class Int256
extends Int {
    public static final BigInteger MAX = BigInteger.valueOf(2L).pow(255);
    public static final BigInteger MAX_INT256 = MAX.subtract(BigInteger.ONE);
    public static final BigInteger MIN_INT256 = MAX.negate();
    public static final Int256 DEFAULT = new Int256(BigInteger.ZERO);

    public Int256(BigInteger value) {
        super(256, value);
        if (value.compareTo(MAX_INT256) > 0 || value.compareTo(MIN_INT256) < 0) {
            throw new UnsupportedOperationException("Int64 should not be greater than  2^255-1 and less than -2^255");
        }
    }

    public Int256(long value) {
        this(BigInteger.valueOf(value));
    }

    public Int256(Int256 value) {
        this(value.getValue());
    }
}

