/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractIntType;
import java.math.BigInteger;

public class Int64
extends AbstractIntType {
    public static final String TYPE_NAME = "int";
    public static final BigInteger MAX_INT64 = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_INT64 = BigInteger.valueOf(Long.MIN_VALUE);
    public static final Int64 DEFAULT = new Int64(BigInteger.ZERO);
    public static final int BYTE_LENGTH = 8;

    public Int64(BigInteger value) {
        this(64, value);
    }

    public Int64(long value) {
        this(BigInteger.valueOf(value));
    }

    public Int64(Int64 value) {
        this(value.getValue());
    }

    protected Int64(int bitSize, BigInteger value) {
        super(TYPE_NAME, bitSize, value);
        if (value.compareTo(MAX_INT64) > 0 || value.compareTo(MIN_INT64) < 0) {
            throw new UnsupportedOperationException("Int64 should not be greater than 9223372036854775807 and less than -9223372036854775808");
        }
    }
}

