/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractIntType;
import java.math.BigInteger;

public class Int8
extends AbstractIntType {
    public static final String TYPE_NAME = "int";
    public static final BigInteger MAX_INT8 = BigInteger.valueOf(127L);
    public static final BigInteger MIN_INT8 = BigInteger.valueOf(-128L);
    public static final Int8 DEFAULT = new Int8(BigInteger.ZERO);
    public static final int BYTE_LENGTH = 1;

    public Int8(BigInteger value) {
        this(8, value);
    }

    public Int8(long value) {
        this(BigInteger.valueOf(value));
    }

    public Int8(Int8 value) {
        this(value.getValue());
    }

    protected Int8(int bitSize, BigInteger value) {
        super(TYPE_NAME, bitSize, value);
        if (value.compareTo(MAX_INT8) > 0 || value.compareTo(MIN_INT8) < 0) {
            throw new UnsupportedOperationException("Int8 should not be  greater than 127 and less than -128");
        }
    }
}

