/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.wasm;

import com.alipay.mychain.sdk.utils.ByteUtils;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes;
import com.alipay.mychain.sdk.vm.abi.datatype.StaticArray;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.wasm.MyWasmTypeEncoder;
import java.util.List;

public final class MyWasmFunctionEncoder {
    private MyWasmFunctionEncoder() {
    }

    public static String encodeConstructor(List<Type> parameters) {
        return MyWasmFunctionEncoder.encodeParameters(parameters, new StringBuilder());
    }

    public static String encodeParameters(List<Type> parameters, StringBuilder result) {
        StringBuilder parameterStringBuilder = new StringBuilder();
        for (Type parameter : parameters) {
            String encodedValue = MyWasmTypeEncoder.encode(parameter);
            parameterStringBuilder.append(encodedValue);
        }
        result.append(MyWasmTypeEncoder.encode(new Bytes(ByteUtils.hexStringToBytes(parameterStringBuilder.toString()))));
        return result.toString();
    }

    public static String buildMethodId(String methodSignature) {
        return MyWasmTypeEncoder.encode(new Utf8String(methodSignature));
    }

    private static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            if (type instanceof StaticArray) {
                count += ((StaticArray)type).getValue().size();
                continue;
            }
            ++count;
        }
        return count;
    }
}

