/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient.admin.impl;

import com.alibaba.fastjson.JSON;
import com.antfinancial.mychain.baas.tool.restclient.RestClient;
import com.antfinancial.mychain.baas.tool.restclient.admin.BlockChainManage;
import com.antfinancial.mychain.baas.tool.restclient.admin.TenantAccessAuthManage;
import com.antfinancial.mychain.baas.tool.restclient.admin.TenantAccessManage;
import com.antfinancial.mychain.baas.tool.restclient.model.BlockChainClientCfg;
import com.antfinancial.mychain.baas.tool.restclient.model.CallRestBizParam;
import com.antfinancial.mychain.baas.tool.restclient.model.Method;
import com.antfinancial.mychain.baas.tool.restclient.response.BaseResp;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;

public class BaaSAdminClient
implements BlockChainManage,
TenantAccessManage,
TenantAccessAuthManage {
    private final String defaultChainSource = "mvp";
    private final int defaultChainVersion = 1;
    @Autowired
    private RestClient restClient;

    @Override
    public BaseResp addBlockChain(String bizId, BlockChainClientCfg clientConfig) throws Exception {
        return this.addBlockChain(bizId, 1, "mvp", clientConfig);
    }

    @Override
    public BaseResp addBlockChain(String bizId, int version, String source, BlockChainClientCfg clientConfig) throws Exception {
        String registerText = this.restClient.createBlockchainConfigRequestStr(JSON.toJSONString((Object)clientConfig), source, version);
        CallRestBizParam restBizParam = CallRestBizParam.builder().method(Method.REGISTERBLOCKCHAINCONFIG).bizid(bizId).requestStr(registerText).orderId(UUID.randomUUID().toString()).build();
        return this.restClient.chainCallForBiz(restBizParam);
    }

    @Override
    public BaseResp addAccessKey(String tenantId, String accessId) throws Exception {
        CallRestBizParam restBizParam = CallRestBizParam.builder().method(Method.ADDACCESSKEY).tenantid(tenantId).applyAccessKey(accessId).orderId(UUID.randomUUID().toString()).build();
        return this.restClient.chainCallForBiz(restBizParam);
    }

    @Override
    public BaseResp authAccess(String accessId, String bizId) throws Exception {
        CallRestBizParam restBizParam = CallRestBizParam.builder().method(Method.ADDACCESSAUTH).bizid(bizId).applyAccessKey(accessId).orderId(UUID.randomUUID().toString()).build();
        return this.restClient.chainCallForBiz(restBizParam);
    }
}

