/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.callback.IProcessBlockHandler;
import com.alipay.mychain.sdk.api.service.EventService;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.event.EventTopicResult;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.message.event.PushTopicsEvent;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import com.alipay.mychain.sdk.utils.ByteUtils;
import com.antfinancial.mychain.baas.tool.restclient.RestClient;
import com.antfinancial.mychain.baas.tool.restclient.model.Method;
import com.antfinancial.mychain.baas.tool.restclient.response.BaseResp;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientReliableEventTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger(RestClientReliableEventTask.class);
    private String eventId;
    private String bizid;
    private RestClient restClient;
    private IEventCallback handler;
    private Set<String> filtererTopics;
    private int blockPullInterval = 0;
    private long lastTopicBlockNumber = 0L;

    public RestClientReliableEventTask(String eventId, String bizid, RestClient restClient, IEventCallback handler, List<String> topics, VMTypeEnum vmTypeEnum, Boolean isPlainTopic, Integer interval, int blockPullInterval) {
        super(interval, TaskType.ALWAYS, null);
        this.eventId = eventId;
        this.bizid = bizid;
        this.restClient = restClient;
        this.handler = handler;
        this.blockPullInterval = blockPullInterval;
        this.filtererTopics = this.contructFilterTopics(topics, vmTypeEnum, isPlainTopic);
    }

    @Override
    public void run() {
        IProcessBlockHandler processBlockHandler = new IProcessBlockHandler(){

            @Override
            public BigInteger getProcessedBlock() {
                BaseResp resp;
                if (RestClientReliableEventTask.this.lastTopicBlockNumber > 0L) {
                    return BigInteger.valueOf(RestClientReliableEventTask.this.lastTopicBlockNumber);
                }
                try {
                    resp = RestClientReliableEventTask.this.restClient.chainCall("", RestClientReliableEventTask.this.eventId, Method.GETEVENTTOPICBLOCKNUM);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!resp.isSuccess()) {
                    throw new RuntimeException("fail to get event point: " + JSON.toJSONString((Object)resp));
                }
                return BigInteger.valueOf(Long.valueOf(resp.getData()));
            }

            @Override
            public void updateProcessedBlock(BigInteger blockNumber) {
                BaseResp resp;
                String requestStr = RestClientReliableEventTask.this.restClient.createUpdateEventTopicRequestStr(RestClientReliableEventTask.this.eventId, blockNumber.toString(), false);
                try {
                    resp = RestClientReliableEventTask.this.restClient.chainCall("", requestStr, Method.UPDATEEVENTTOPICBLOCKNUM);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!resp.isSuccess()) {
                    throw new RuntimeException("fail to update event point: " + JSON.toJSONString((Object)resp));
                }
                RestClientReliableEventTask.this.lastTopicBlockNumber = blockNumber.longValue();
            }
        };
        BigInteger lastProcessedBlockNumber = processBlockHandler.getProcessedBlock();
        try {
            BaseResp resp = this.restClient.chainCall("", this.bizid, "", Method.QUERYLASTBLOCK);
            if (!resp.isSuccess()) {
                throw new RuntimeException("fail to query last block: " + JSON.toJSONString((Object)resp));
            }
            JSONObject lastBlockInfo = JSONObject.parseObject((String)resp.getData());
            BigInteger lastChainBlockNumber = BigInteger.valueOf(Long.valueOf(lastBlockInfo.getJSONObject("block").getJSONObject("blockHeader").getString("number")));
            if (lastChainBlockNumber.compareTo(lastProcessedBlockNumber) <= 0) {
                return;
            }
            BigInteger start = lastProcessedBlockNumber.add(BigInteger.ONE);
            BigInteger end = lastChainBlockNumber.subtract(lastProcessedBlockNumber).compareTo(BigInteger.valueOf(99L)) > 0 ? start.add(BigInteger.valueOf(99L)) : lastChainBlockNumber;
            logger.info("process block from {} to {}", (Object)start.longValue(), (Object)end.longValue());
            while (start.compareTo(end) <= 0) {
                ArrayList<EventTopicResult> results = new ArrayList<EventTopicResult>();
                resp = this.restClient.chainCall("", this.bizid, start.toString(), Method.QUERYBLOCKBODY);
                if (!resp.isSuccess()) {
                    throw new RuntimeException("fail to query block: " + JSON.toJSONString((Object)resp));
                }
                logger.info("process block {}", (Object)start.longValue());
                JSONObject root = JSONObject.parseObject((String)resp.getData());
                JSONArray transactionList = root.getJSONObject("body").getJSONArray("transaction_list");
                ArrayList<Hash> hashes = new ArrayList<Hash>();
                for (int i = 0; i < transactionList.size(); ++i) {
                    hashes.add(new Hash(transactionList.getJSONObject(i).getString("hash")));
                }
                JSONArray receipts = root.getJSONObject("body").getJSONArray("receipt_list");
                for (int i = 0; i < receipts.size(); ++i) {
                    JSONObject receipt = receipts.getJSONObject(i);
                    JSONArray logEntries = receipt.getJSONArray("logs");
                    for (int j = 0; j < logEntries.size(); ++j) {
                        JSONObject logEntry = logEntries.getJSONObject(j);
                        JSONArray realTopics = logEntry.getJSONArray("topics");
                        for (int k = 0; k < realTopics.size(); ++k) {
                            String topic = realTopics.getString(k);
                            if (!this.filtererTopics.contains(topic)) continue;
                            EventTopicResult eventTopicResult = new EventTopicResult(topic, logEntry.getBytes("log_data"), new Identity(logEntry.getString("to")), (Hash)hashes.get(i));
                            results.add(eventTopicResult);
                        }
                    }
                }
                start = start.add(BigInteger.ONE);
                if (results.size() > 0) {
                    PushTopicsEvent pushTopicsEvent = new PushTopicsEvent(BigInteger.valueOf(1L), results);
                    this.handler.onEvent(pushTopicsEvent);
                }
                processBlockHandler.updateProcessedBlock(end);
                if (this.blockPullInterval <= 0) continue;
                TimeUnit.MILLISECONDS.sleep(this.blockPullInterval);
            }
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            System.err.println("fail to run task:" + e.getMessage());
            e.printStackTrace();
        }
    }

    private Set<String> contructFilterTopics(List<String> topics, VMTypeEnum vmType, Boolean isPlainTopic) {
        HashSet<String> filteredTopics;
        block9: {
            block10: {
                block8: {
                    filteredTopics = new HashSet<String>();
                    if (!isPlainTopic.booleanValue()) break block8;
                    for (String topic : topics) {
                        if (EventService.getTOPICS().contains(topic)) {
                            filteredTopics.add(topic);
                            continue;
                        }
                        try {
                            filteredTopics.add(ByteUtils.toHexString(topic.getBytes("iso-8859-1")));
                        }
                        catch (Exception e) {
                            MychainSdkException.throwInvalidParameters(e.getMessage());
                        }
                    }
                    break block9;
                }
                if (VMTypeEnum.EVM.getCode() != vmType.getCode()) break block10;
                for (String topic : topics) {
                    if (EventService.getTOPICS().contains(topic)) {
                        filteredTopics.add(topic);
                        continue;
                    }
                    filteredTopics.add(ByteUtils.toHexString(HashFactory.getHash(HashTypeEnum.Keccak).hash(ByteUtils.stringToByteArray(topic))));
                }
                break block9;
            }
            if (VMTypeEnum.WASM.getCode() != vmType.getCode()) break block9;
            for (String topic : topics) {
                if (EventService.getTOPICS().contains(topic)) {
                    filteredTopics.add(topic);
                    continue;
                }
                filteredTopics.add(ByteUtils.toHexString(topic));
            }
        }
        return filteredTopics;
    }
}

