/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient.request;

import com.alibaba.fastjson.JSON;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.message.transaction.contract.CallContractRequest;
import com.alipay.mychain.sdk.vm.EVMParameter;
import com.alipay.mychain.sdk.vm.NativeCallParameters;
import com.alipay.mychain.sdk.vm.WASMParameter;
import com.antfinancial.mychain.baas.tool.restclient.model.CallContractRequestWithSignature;
import com.antfinancial.mychain.baas.tool.restclient.model.CallNativeContractRequestWithSignature;
import com.antfinancial.mychain.baas.tool.restclient.model.CallWasmContractRequestWithSignature;
import com.antfinancial.mychain.baas.tool.restclient.model.ClientParam;
import com.antfinancial.mychain.baas.tool.restclient.request.ConstructAbstractRequest;
import com.antfinancial.mychain.baas.tool.restclient.utils.MytfSdkAdaptUtil;
import com.antfinancial.mychain.baas.tool.utils.ContractParameterUtils;
import com.antfinancial.mychain.baas.tool.utils.NativeContractParameterUtils;
import com.antfinancial.mychain.baas.tool.utils.WasmParaUtils;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;

public class ConstructCallContractRequest
extends ConstructAbstractRequest {
    public ClientParam createCallContractTransaction(Identity account, Identity contract, String outTypes, String methodSignature, String inputParamListStr, Boolean isLocalTransaction, BigInteger blockNumber, Long gas, List<SignerBase> signerBases, VMTypeEnum vmTypeEnum, NativeCallParameters nativeCallParameters, String teePublicKey, String secretKey) {
        AbstractTransactionRequest request = null;
        if (vmTypeEnum == VMTypeEnum.EVM) {
            EVMParameter contractParameters = new EVMParameter(methodSignature);
            ContractParameterUtils.addParameter4Contract(contractParameters, methodSignature, inputParamListStr);
            request = new CallContractRequest(account, contract, contractParameters, BigInteger.ZERO, VMTypeEnum.EVM);
            MytfSdkAdaptUtil.setTxGas(request, gas);
        } else if (vmTypeEnum == VMTypeEnum.WASM) {
            String methodName = methodSignature.substring(0, methodSignature.indexOf(40));
            WASMParameter wasmContractParameters = new WASMParameter(methodName);
            WasmParaUtils.addParameter4Wasm(wasmContractParameters, methodSignature, inputParamListStr);
            request = new CallContractRequest(account, contract, wasmContractParameters, BigInteger.ZERO, VMTypeEnum.WASM);
        } else if (vmTypeEnum == VMTypeEnum.NATIVE) {
            if (nativeCallParameters == null) {
                nativeCallParameters = new NativeCallParameters();
                NativeContractParameterUtils.addParameter4Contract(nativeCallParameters, methodSignature, inputParamListStr);
            }
            request = new CallContractRequest(account, contract, nativeCallParameters, BigInteger.ZERO, VMTypeEnum.NATIVE);
        }
        MytfSdkAdaptUtil.setTxGas(request, gas);
        if (BooleanUtils.isTrue((Boolean)isLocalTransaction)) {
            if (blockNumber != null && blockNumber.compareTo(BigInteger.ZERO) >= 0) {
                request.setLocal(blockNumber);
            } else {
                request.setLocal();
            }
        }
        this.completeRequest(request);
        Transaction transaction = request.getTransaction();
        transaction.calcSignature(signerBases);
        String body = null;
        if (vmTypeEnum == VMTypeEnum.EVM) {
            CallContractRequestWithSignature callContractRequestWithSignature = new CallContractRequestWithSignature();
            callContractRequestWithSignature.setCallContractRaw(request.toRlp());
            callContractRequestWithSignature.setHash(transaction.getHash().hexStrValue());
            callContractRequestWithSignature.setTimestamp(transaction.getTimestamp());
            body = JSON.toJSONString((Object)callContractRequestWithSignature);
        } else if (vmTypeEnum == VMTypeEnum.WASM) {
            CallWasmContractRequestWithSignature callWasmContractRequestWithSignature = new CallWasmContractRequestWithSignature();
            callWasmContractRequestWithSignature.setCallWasmContractRaw(request.toRlp());
            callWasmContractRequestWithSignature.setHash(transaction.getHash().hexStrValue());
            callWasmContractRequestWithSignature.setTimestamp(transaction.getTimestamp());
            callWasmContractRequestWithSignature.setTeePublicKey(teePublicKey);
            callWasmContractRequestWithSignature.setSecretKey(secretKey);
            body = JSON.toJSONString((Object)callWasmContractRequestWithSignature);
        } else if (vmTypeEnum == VMTypeEnum.NATIVE) {
            CallNativeContractRequestWithSignature callNativeContractRequestWithSignature = new CallNativeContractRequestWithSignature();
            callNativeContractRequestWithSignature.setCallNativeContractRaw(request.toRlp());
            callNativeContractRequestWithSignature.setHash(transaction.getHash().hexStrValue());
            callNativeContractRequestWithSignature.setTimestamp(transaction.getTimestamp());
            body = JSON.toJSONString((Object)callNativeContractRequestWithSignature);
        }
        ClientParam clientCallContractParam = new ClientParam();
        clientCallContractParam.setHash(transaction.getHash().hexStrValue());
        clientCallContractParam.setSignData(body);
        return clientCallContractParam;
    }
}

