/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient.request;

import com.alibaba.fastjson.JSON;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.message.transaction.account.DepositDataRequest;
import com.antfinancial.mychain.baas.tool.restclient.model.ClientParam;
import com.antfinancial.mychain.baas.tool.restclient.model.DepositWithSignature;
import com.antfinancial.mychain.baas.tool.restclient.request.ConstructAbstractRequest;
import com.antfinancial.mychain.baas.tool.restclient.utils.MytfSdkAdaptUtil;
import java.math.BigInteger;
import java.util.List;

public class ConstructDepositRequest
extends ConstructAbstractRequest {
    public ClientParam createDepositTransaction(Identity account, byte[] content, Long gas, List<SignerBase> signerBases) throws Exception {
        DepositDataRequest request = new DepositDataRequest(account, account, content, BigInteger.valueOf(0L));
        MytfSdkAdaptUtil.setTxGas(request, gas);
        this.completeRequest(request);
        Transaction transaction = request.getTransaction();
        transaction.calcSignature(signerBases);
        DepositWithSignature depositWithSignature = new DepositWithSignature();
        depositWithSignature.setDepositRaw(request.toRlp());
        depositWithSignature.setHash(transaction.getHash().hexStrValue());
        depositWithSignature.setTimestamp(transaction.getTimestamp());
        ClientParam clientCallContractParam = new ClientParam();
        clientCallContractParam.setHash(transaction.getHash().hexStrValue());
        clientCallContractParam.setSignData(JSON.toJSONString((Object)depositWithSignature));
        return clientCallContractParam;
    }
}

