/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient.request;

import com.alibaba.fastjson.JSON;
import com.alipay.mychain.sdk.api.utils.Utils;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.message.transaction.contract.UpdateContractRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import com.alipay.mychain.sdk.utils.RandomUtil;
import com.antfinancial.mychain.baas.tool.restclient.model.ClientParam;
import com.antfinancial.mychain.baas.tool.restclient.utils.MytfSdkAdaptUtil;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class UpdateContractRequestBuilder {
    public static ClientParam createUpdateContractTransaction(String account, String contractName, byte[] code, VMTypeEnum vmTypeEnum, Long gas, List<SignerBase> signerBases, String secretKey) {
        UpdateContractRequest sdkRequest = new UpdateContractRequest(Utils.getIdentityByName(contractName), code, vmTypeEnum);
        if (gas == null) {
            gas = 0L;
        }
        MytfSdkAdaptUtil.setTxGas(sdkRequest, gas);
        UpdateContractRequestBuilder.completeRequest(sdkRequest);
        Transaction transaction = sdkRequest.getTransaction();
        transaction.calcSignature(signerBases);
        com.antfinancial.mychain.baas.tool.restclient.model.UpdateContractRequest request = com.antfinancial.mychain.baas.tool.restclient.model.UpdateContractRequest.builder().contractName(Hex.encodeHexString((byte[])Utils.getIdentityByName(contractName).getValue())).contractCode(Base64.encodeBase64String((byte[])code)).updateContractRaw(sdkRequest.toRlp()).vmType(vmTypeEnum.name()).secretKey(secretKey).build();
        ClientParam clientParam = new ClientParam();
        clientParam.setHash(transaction.getHash().hexStrValue());
        clientParam.setSignData(JSON.toJSONString((Object)request));
        return clientParam;
    }

    protected static void completeRequest(AbstractTransactionRequest request) {
        long ts = System.currentTimeMillis();
        request.setTxTimeNonce(ts, BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(RandomUtil.randomize(ts + (long)request.getTransaction().hashCode())), false);
        request.complete();
    }
}

