/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CertUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertUtil.class);
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static String sign(String plain, String priKey) throws Exception {
        PrivateKey privateKey = CertUtil.getPrivateKey(priKey);
        Signature signature = Signature.getInstance("Sha256WithRSA");
        signature.initSign(privateKey);
        signature.update(plain.getBytes("UTF-8"));
        byte[] signed = signature.sign();
        return new String(Hex.encode((byte[])signed));
    }

    public static boolean rsaCert(String plain, String signedData, String pubkey) throws Exception {
        PublicKey publicKey = CertUtil.getPublicKey(pubkey);
        Signature signature2 = Signature.getInstance("Sha256WithRSA");
        signature2.initVerify(publicKey);
        signature2.update(plain.getBytes("UTF-8"));
        return signature2.verify(Hex.decode((String)signedData));
    }

    public static PublicKey getPublicKey(String pubKey) throws Exception {
        byte[] bytesPublicBase64 = CertUtil.readKeyDatas(pubKey);
        byte[] bytesPublic = Base64.decode((byte[])bytesPublicBase64);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytesPublic);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (InvalidKeySpecException e) {
            throw e;
        }
    }

    public static PrivateKey getPrivateKey(String priKey) throws Exception {
        byte[] bytesPrivateBase64 = CertUtil.readKeyDatas(priKey);
        byte[] bytesPrivate = Base64.decode((byte[])bytesPrivateBase64);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytesPrivate);
        KeyFactory keyFactory = null;
        keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    private static byte[] readKeyDatas(String key) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(key));
        String str = null;
        StringBuilder stringBuilder = new StringBuilder();
        while ((str = bufferedReader.readLine()) != null) {
            if (str.contains("---")) continue;
            stringBuilder.append(str);
        }
        return stringBuilder.toString().getBytes();
    }

    public static byte[] doEncrypt(PublicKey publicKey, byte[] srcBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (publicKey != null) {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            byte[] resultBytes = cipher.doFinal(srcBytes);
            return resultBytes;
        }
        return null;
    }

    public static byte[] encrypt(PublicKey publicKey, byte[] srcBytes) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (publicKey != null) {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            int inputLen = srcBytes.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(srcBytes, offSet, 117) : cipher.doFinal(srcBytes, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return encryptedData;
        }
        return null;
    }

    public static byte[] doDecrypt(PrivateKey privateKey, byte[] srcBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (privateKey != null) {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            byte[] resultBytes = cipher.doFinal(srcBytes);
            return resultBytes;
        }
        return null;
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] srcBytes) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (privateKey != null) {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            int inputLen = srcBytes.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(srcBytes, offSet, 128) : cipher.doFinal(srcBytes, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return decryptedData;
        }
        return null;
    }

    public String entryptOpenSSLSha256(String content, String privateKey) {
        return "";
    }

    public String entryptBase64(String content) {
        return "";
    }
}

