/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.vm.EVMOutput;
import com.alipay.mychain.sdk.vm.EVMParameter;
import com.antfinancial.mychain.baas.tool.utils.SolidityVarType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ContractParameterUtils {
    public static void addParameter4Contract(EVMParameter contractParameters, String methodSignature, String inputParamListStr) {
        String argStr = methodSignature.substring(methodSignature.indexOf(40) + 1).replace(")", "");
        if (StringUtils.isBlank((CharSequence)argStr)) {
            return;
        }
        String[] args = argStr.split(",");
        JSONArray inputParamList = JSONArray.parseArray((String)inputParamListStr);
        block12: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (SolidityVarType.fromCode(arg)) {
                case INT: {
                    contractParameters.addInt(inputParamList.getBigInteger(i));
                    continue block12;
                }
                case INT_ARRAY: {
                    contractParameters.addIntArray(inputParamList.getJSONArray(i).toJavaList(BigInteger.class));
                    continue block12;
                }
                case UINT: {
                    contractParameters.addUint(inputParamList.getBigInteger(i));
                    continue block12;
                }
                case UINT_ARRAY: {
                    contractParameters.addUintArray(inputParamList.getJSONArray(i).toJavaList(BigInteger.class));
                    continue block12;
                }
                case BOOL: {
                    contractParameters.addBool(inputParamList.getBoolean(i));
                    continue block12;
                }
                case BOOL_ARRAY: {
                    contractParameters.addBooleanArray(inputParamList.getJSONArray(i).toJavaList(Boolean.class));
                    continue block12;
                }
                case IDENTITY: {
                    contractParameters.addIdentity((Hash)inputParamList.getObject(i, Identity.class));
                    continue block12;
                }
                case IDENTITY_ARRAY: {
                    contractParameters.addBytes32Array(inputParamList.getJSONArray(i).toJavaList(byte[].class));
                    continue block12;
                }
                case STRING: {
                    contractParameters.addString(inputParamList.getString(i));
                    continue block12;
                }
                case BYTES: {
                    contractParameters.addBytes((byte[])inputParamList.getObject(i, byte[].class));
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unsupported function parameter type: " + arg);
                }
            }
        }
    }

    public static List<Object> getEVMOutput(EVMOutput contractReturnValues, List<String> output) {
        ArrayList<Object> outRes = new ArrayList<Object>();
        block11: for (int i = 0; i < output.size(); ++i) {
            switch (SolidityVarType.fromCode(output.get(i))) {
                case INT: {
                    outRes.add(contractReturnValues.getInt());
                    continue block11;
                }
                case INT_ARRAY: {
                    outRes.add(contractReturnValues.getIntDynamicArray());
                    continue block11;
                }
                case UINT: {
                    outRes.add(contractReturnValues.getUint());
                    continue block11;
                }
                case UINT_ARRAY: {
                    outRes.add(JSON.toJSONString(contractReturnValues.getUintDynamicArray()));
                    continue block11;
                }
                case BOOL: {
                    outRes.add(contractReturnValues.getBoolean());
                    continue block11;
                }
                case BOOL_ARRAY: {
                    outRes.add(contractReturnValues.getBooleanDynamicArray());
                    continue block11;
                }
                case IDENTITY: {
                    outRes.add(contractReturnValues.getIdentity().hexStrValue());
                    continue block11;
                }
                case STRING: {
                    outRes.add(contractReturnValues.getString());
                    continue block11;
                }
                case BYTES: {
                    outRes.add(contractReturnValues.getBytes());
                    continue block11;
                }
                default: {
                    throw new RuntimeException("Unsupported function return type: " + output.get(i));
                }
            }
        }
        return outRes;
    }
}

