/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.utils;

import org.apache.commons.lang3.StringUtils;

public enum SolidityVarType {
    UNSUPPORTED,
    INT,
    INT64,
    INT_ARRAY,
    INT64_ARRAY,
    UINT,
    UINT_ARRAY,
    BOOL,
    BOOL_ARRAY,
    BYTES,
    ENCODEDBYTES,
    BYTES_ARRAY,
    BYTES_LIST,
    IDENTITY,
    IDENTITY_ARRAY,
    STRING;

    private static final String ARRAY_INDICATOR = "[]";
    private static final String IDENTITY_TYPE_CODE = "identity";
    private static final String LIST_BYTES_CODE = "list(bytes)";
    private static final String ENCODED_BYTES = "encodedbytes";

    public static SolidityVarType fromCode(String code) {
        if (StringUtils.startsWith((CharSequence)code, (CharSequence)"int")) {
            return SolidityVarType.isArray(code) ? INT_ARRAY : INT;
        }
        if (StringUtils.startsWith((CharSequence)code, (CharSequence)"uint")) {
            return SolidityVarType.isArray(code) ? UINT_ARRAY : UINT;
        }
        if (StringUtils.startsWith((CharSequence)code, (CharSequence)"int64")) {
            return SolidityVarType.isArray(code) ? INT64_ARRAY : INT64;
        }
        if (StringUtils.startsWith((CharSequence)code, (CharSequence)"bool")) {
            return SolidityVarType.isArray(code) ? BOOL_ARRAY : BOOL;
        }
        if (StringUtils.startsWith((CharSequence)code, (CharSequence)IDENTITY_TYPE_CODE)) {
            return SolidityVarType.isArray(code) ? IDENTITY_ARRAY : IDENTITY;
        }
        if (StringUtils.equals((CharSequence)code, (CharSequence)"string")) {
            return STRING;
        }
        if (StringUtils.equals((CharSequence)code, (CharSequence)ENCODED_BYTES)) {
            return ENCODEDBYTES;
        }
        if (StringUtils.startsWith((CharSequence)code, (CharSequence)"bytes")) {
            return SolidityVarType.isArray(code) ? BYTES_ARRAY : BYTES;
        }
        if (StringUtils.equals((CharSequence)code, (CharSequence)LIST_BYTES_CODE)) {
            return BYTES_LIST;
        }
        return UNSUPPORTED;
    }

    private static boolean isArray(String code) {
        return StringUtils.endsWith((CharSequence)code, (CharSequence)ARRAY_INDICATOR);
    }
}

