/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.eInvoice.mycrypto;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;

public final class NativeUtils {
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static final int MIN_PREFIX_LENGTH = 3;
    private static File temporaryDir;
    private static String Slash;

    private NativeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadLibraryFromJar(String path) throws IOException {
        Class<NativeUtils> clazz = NativeUtils.class;
        synchronized (NativeUtils.class) {
            boolean loaded;
            String filename;
            if (null == path || !path.startsWith(Slash)) {
                throw new IllegalArgumentException("The path has to be absolute (start with '/').");
            }
            String[] parts = path.split(Slash);
            String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
            if (filename == null || filename.length() < 3) {
                throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
            }
            if (temporaryDir == null) {
                temporaryDir = NativeUtils.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
                temporaryDir.deleteOnExit();
            }
            File temp = new File(temporaryDir, filename);
            try (InputStream is = NativeUtils.class.getResourceAsStream(path);){
                Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                temp.delete();
                throw e;
            }
            catch (Exception e) {
                temp.delete();
                throw new IOException("File " + path + " was not found inside JAR.", e);
            }
            try {
                System.load(temp.getAbsolutePath());
                loaded = true;
            }
            finally {
                if (NativeUtils.isPosixCompliant()) {
                    temp.delete();
                } else {
                    temp.deleteOnExit();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loaded;
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    private static File createTempDirectory(String prefix) throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, prefix + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }

    static {
        Slash = "/";
    }
}

