/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.spv;

import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.service.spv.SpvImp;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.spv.QueryBlockHeaderInfosRequest;
import com.alipay.mychain.sdk.message.spv.QueryBlockHeaderInfosResponse;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import java.math.BigInteger;

public class SpvTask
extends AbstractTask {
    private INetwork network;
    private SpvImp spvImp;
    private BigInteger blockNum;
    private Integer blockAmount;
    private Integer timeout;
    private Boolean inProcess = Boolean.FALSE;

    public SpvTask(SpvImp spvImp, INetwork network, ILogger logger, BigInteger blockNum, Integer blockAmount, Integer intervalMs, Integer timeout) {
        super(intervalMs, TaskType.ALWAYS, logger);
        this.network = network;
        this.spvImp = spvImp;
        this.blockNum = blockNum;
        this.blockAmount = blockAmount;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.spvImp == null || this.network == null) {
            return;
        }
        SpvTask spvTask = this;
        synchronized (spvTask) {
            if (this.inProcess.booleanValue()) {
                return;
            }
            this.inProcess = true;
        }
        BigInteger startBlockNum = this.blockNum.add(BigInteger.ONE);
        this.network.sendAsyncRequest(new QueryBlockHeaderInfosRequest(startBlockNum, this.blockAmount.longValue()), new Hash(), new IAsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(int errorCode, Response response) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    SpvTask.this.inProcess = false;
                }
                if (ErrorCode.SUCCESS.getErrorCode() != errorCode) {
                    return;
                }
                if (ErrorCode.SUCCESS != response.getErrorCode()) {
                    return;
                }
                QueryBlockHeaderInfosResponse queryResponse = (QueryBlockHeaderInfosResponse)response;
                SpvTask.this.blockNum = BigInteger.valueOf(SpvTask.this.spvImp.verifyBlocks(SpvTask.this.blockNum.longValue(), queryResponse.getBlockHeaderInfoList()));
            }
        }, this.timeout);
    }
}

