/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryBlockHeaderRequest
extends Request {
    private BigInteger blockNumber = BigInteger.ZERO;
    private Hash blockHash = new Hash();

    public QueryBlockHeaderRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER);
    }

    public QueryBlockHeaderRequest(BigInteger blockNumber) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER);
        this.blockNumber = blockNumber;
    }

    public QueryBlockHeaderRequest(Hash blockHash) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER);
        this.blockHash = blockHash;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public Hash getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(Hash blockHash) {
        this.blockHash = blockHash;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (this.blockNumber != null || this.blockHash != null && !this.blockHash.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue())) && this.blockNumber.compareTo(BigInteger.ZERO) >= 0;
    }

    @Override
    public byte[] toRlp() {
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNumber);
        byte[] blockHashBytes = Rlp.encodeElement(this.blockHash.getValue());
        return Rlp.encodeList(super.toRlp(), blockNumberBytes, blockHashBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.blockHash = new Hash(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.blockHash.getValue()));
        jsonObject.put("block_number", (Object)this.blockNumber);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.blockHash = new Hash(jsonObject.getString("hash"));
        this.blockNumber = jsonObject.getBigInteger("block_number");
    }
}

