/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryNodeTimestampResponse
extends Response {
    private long timestamp;

    public QueryNodeTimestampResponse() {
        super(MessageType.MSG_TYPE_QUERY_RESP_TS);
    }

    public QueryNodeTimestampResponse(long timestamp) {
        super(MessageType.MSG_TYPE_QUERY_RESP_TS);
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public byte[] toRlp() {
        byte[] timestampBytes = Rlp.encodeLong(this.timestamp);
        return Rlp.encodeList(super.toRlp(), timestampBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.timestamp = ByteUtils.byteArrayToLong(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("timestamp", (Object)this.timestamp);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.timestamp = jsonObject.getLong("timestamp");
    }
}

