/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.spv;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryBlockBodiesRequest
extends Request {
    private List<Hash> blockHashes;

    public QueryBlockBodiesRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_BODY_INFOS);
    }

    public QueryBlockBodiesRequest(List<Hash> blockHashes) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_BODY_INFOS);
        this.blockHashes = blockHashes;
    }

    public List<Hash> getBlockHashes() {
        return this.blockHashes;
    }

    public void setBlockHashes(List<Hash> blockHashes) {
        this.blockHashes = blockHashes;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.blockHashes != null && this.blockHashes.size() > 0;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (Hash item : this.blockHashes) {
            data.add(Rlp.encodeElement(item.getValue()));
        }
        return Rlp.encodeList(super.toRlp(), Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.blockHashes = new ArrayList<Hash>();
        RlpList data = (RlpList)list.get(1);
        for (RlpElement element : data) {
            Hash item = new Hash(element.getRlpData());
            this.blockHashes.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONArray jsonArray = new JSONArray();
        if (this.blockHashes != null) {
            for (Hash item : this.blockHashes) {
                jsonArray.add((Object)ByteUtils.toHexString(item.getValue()));
            }
        }
        jsonObject.put("block_hashes", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.blockHashes = new ArrayList<Hash>();
        JSONArray jsonArray = jsonObject.getJSONArray("block_hashes");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                Hash object = new Hash((String)iterator.next());
                this.blockHashes.add(object);
            }
        }
    }
}

